/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.cluster.management.raft.RaftStorageManager;
import org.apache.ignite.internal.cluster.management.raft.ValidationManager;
import org.apache.ignite.internal.cluster.management.raft.ValidationResult;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.InitCmgStateCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.JoinReadyCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.JoinRequestCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.NodesLeaveCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.ReadLogicalTopologyCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.ReadStateCommand;
import org.apache.ignite.internal.cluster.management.raft.responses.LogicalTopologyResponse;
import org.apache.ignite.internal.cluster.management.raft.responses.ValidationErrorResponse;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.raft.client.ReadCommand;
import org.apache.ignite.raft.client.WriteCommand;
import org.apache.ignite.raft.client.service.CommandClosure;
import org.apache.ignite.raft.client.service.RaftGroupListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CmgRaftGroupListener
implements RaftGroupListener {
    private static final IgniteLogger LOG = Loggers.forClass(CmgRaftGroupListener.class);
    private final RaftStorageManager storage;
    private final ValidationManager validationManager;

    public CmgRaftGroupListener(ClusterStateStorage storage) {
        this.storage = new RaftStorageManager(storage);
        this.validationManager = new ValidationManager(this.storage);
    }

    public void onRead(Iterator<CommandClosure<ReadCommand>> iterator) {
        while (iterator.hasNext()) {
            CommandClosure<ReadCommand> clo = iterator.next();
            ReadCommand command = (ReadCommand)clo.command();
            if (command instanceof ReadStateCommand) {
                clo.result((Serializable)this.storage.getClusterState());
                continue;
            }
            if (!(command instanceof ReadLogicalTopologyCommand)) continue;
            clo.result((Serializable)new LogicalTopologyResponse(this.storage.getLogicalTopology()));
        }
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iterator) {
        while (iterator.hasNext()) {
            Object response;
            CommandClosure<WriteCommand> clo = iterator.next();
            WriteCommand command = (WriteCommand)clo.command();
            if (command instanceof InitCmgStateCommand) {
                response = this.initCmgState((InitCmgStateCommand)command);
                clo.result((Serializable)response);
                continue;
            }
            if (command instanceof JoinRequestCommand) {
                response = this.validateNode((JoinRequestCommand)command);
                clo.result((Serializable)(((ValidationResult)response).isValid() ? null : new ValidationErrorResponse(((ValidationResult)response).errorDescription())));
                continue;
            }
            if (command instanceof JoinReadyCommand) {
                response = this.completeValidation((JoinReadyCommand)command);
                clo.result((Serializable)response);
                continue;
            }
            if (!(command instanceof NodesLeaveCommand)) continue;
            this.removeNodesFromLogicalTopology((NodesLeaveCommand)command);
            clo.result(null);
        }
    }

    @Nullable
    private Serializable initCmgState(InitCmgStateCommand command) {
        ClusterState state = this.storage.getClusterState();
        if (state == null) {
            this.storage.putClusterState(command.clusterState());
            return command.clusterState();
        }
        ValidationResult validationResult = ValidationManager.validateState(state, command.node().asClusterNode(), command.clusterState());
        return validationResult.isValid() ? state : new ValidationErrorResponse(validationResult.errorDescription());
    }

    private ValidationResult validateNode(JoinRequestCommand command) {
        return this.validationManager.validateNode(this.storage.getClusterState(), command.node().asClusterNode(), command.igniteVersion(), command.clusterTag());
    }

    @Nullable
    private Serializable completeValidation(JoinReadyCommand command) {
        ClusterNode node = command.node().asClusterNode();
        if (this.validationManager.isNodeValidated(node)) {
            this.storage.putLogicalTopologyNode(node);
            LOG.info("Node added to the logical topology [node={}]", new Object[]{node.name()});
            this.validationManager.completeValidation(node);
            return null;
        }
        return new ValidationErrorResponse(String.format("Node \"%s\" has not yet passed the validation step", node));
    }

    private void removeNodesFromLogicalTopology(NodesLeaveCommand command) {
        Set<ClusterNode> nodes = command.nodes().stream().map(ClusterNodeMessage::asClusterNode).collect(Collectors.toSet());
        this.storage.removeLogicalTopologyNodes(nodes);
        if (LOG.isInfoEnabled()) {
            LOG.info("Nodes removed from the logical topology [nodes={}]", new Object[]{nodes.stream().map(ClusterNode::name).collect(Collectors.toList())});
        }
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        this.storage.snapshot(path).whenComplete((unused, throwable) -> doneClo.accept((Throwable)throwable));
    }

    public boolean onSnapshotLoad(Path path) {
        try {
            this.storage.restoreSnapshot(path);
            return true;
        }
        catch (IgniteInternalException e) {
            LOG.debug("Failed to restore snapshot [path={}]", new Object[]{path, e});
            return false;
        }
    }

    public void onShutdown() {
        this.validationManager.close();
    }

    @TestOnly
    public RaftStorageManager storage() {
        return this.storage;
    }
}

