/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.distributed.TableMessagesFactory;
import org.apache.ignite.internal.table.distributed.replication.request.ReadOnlyScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.table.distributed.replication.request.ReadWriteScanRetrieveBatchReplicaRequestBuilder;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.replicator.action.RequestType;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFiveFunction;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteTetraFunction;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InternalTableImpl
implements InternalTable {
    private static final AtomicLong CURSOR_ID_GENERATOR = new AtomicLong();
    private static final int ATTEMPTS_TO_ENLIST_PARTITION = 5;
    protected final Int2ObjectMap<RaftGroupService> partitionMap;
    private final int partitions;
    private final String tableName;
    private final UUID tableId;
    private final Function<NetworkAddress, String> netAddrResolver;
    private final Function<NetworkAddress, ClusterNode> clusterNodeResolver;
    protected final TxManager txManager;
    private final MvTableStorage tableStorage;
    private final TxStateTableStorage txStateStorage;
    protected final ReplicaService replicaSvc;
    private final Object updatePartMapMux = new Object();
    private final TableMessagesFactory tableMessagesFactory;
    private final HybridClock clock;

    public InternalTableImpl(String tableName, UUID tableId, Int2ObjectMap<RaftGroupService> partMap, int partitions, Function<NetworkAddress, String> netAddrResolver, Function<NetworkAddress, ClusterNode> clusterNodeResolver, TxManager txManager, MvTableStorage tableStorage, TxStateTableStorage txStateStorage, ReplicaService replicaSvc, HybridClock clock) {
        this.tableName = tableName;
        this.tableId = tableId;
        this.partitionMap = partMap;
        this.partitions = partitions;
        this.netAddrResolver = netAddrResolver;
        this.clusterNodeResolver = clusterNodeResolver;
        this.txManager = txManager;
        this.tableStorage = tableStorage;
        this.txStateStorage = txStateStorage;
        this.replicaSvc = replicaSvc;
        this.tableMessagesFactory = new TableMessagesFactory();
        this.clock = clock;
    }

    @Override
    public MvTableStorage storage() {
        return this.tableStorage;
    }

    @Override
    public int partitions() {
        return this.partitions;
    }

    @Override
    public UUID tableId() {
        return this.tableId;
    }

    @Override
    public String name() {
        return this.tableName;
    }

    private <R> CompletableFuture<R> enlistInTx(BinaryRowEx row, InternalTransaction tx, IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest> op) {
        CompletableFuture fut;
        int partId;
        TablePartitionId partGroupId;
        if (tx != null && tx.isReadOnly()) {
            return CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_INSUFFICIENT_READ_WRITE_OPERATION_ERR, "Failed to enlist read-write operation into read-only transaction txId={" + tx.id() + "}"));
        }
        boolean implicit = tx == null;
        InternalTransaction tx0 = implicit ? this.txManager.begin() : tx;
        IgniteBiTuple primaryReplicaAndTerm = tx0.enlistedNodeAndTerm((ReplicationGroupId)(partGroupId = new TablePartitionId(this.tableId, partId = this.partId(row))));
        if (primaryReplicaAndTerm != null) {
            TablePartitionId commitPart2 = (TablePartitionId)tx.commitPartition();
            ReplicaRequest request = (ReplicaRequest)op.apply((Object)commitPart2, (Object)tx0, (Object)partGroupId, (Object)((Long)primaryReplicaAndTerm.get2()));
            try {
                fut = this.replicaSvc.invoke((ClusterNode)primaryReplicaAndTerm.get1(), request);
            }
            catch (PrimaryReplicaMissException e) {
                throw new TransactionException((Throwable)e);
            }
            catch (Throwable e) {
                throw new TransactionException("Failed to invoke the replica request.");
            }
        } else {
            fut = this.enlistWithRetry(tx0, partId, (commitPart, term) -> (ReplicaRequest)op.apply(commitPart, (Object)tx0, (Object)partGroupId, term), 5);
        }
        return this.postEnlist(fut, implicit, tx0);
    }

    private <T> CompletableFuture<T> enlistInTx(Collection<BinaryRowEx> keyRows, InternalTransaction tx, IgniteFiveFunction<TablePartitionId, Collection<BinaryRow>, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest> op, Function<CompletableFuture<Object>[], CompletableFuture<T>> reducer) {
        boolean implicit;
        if (tx != null && tx.isReadOnly()) {
            return CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_INSUFFICIENT_READ_WRITE_OPERATION_ERR, "Failed to enlist read-write operation into read-only transaction txId={" + tx.id() + "}"));
        }
        boolean bl = implicit = tx == null;
        if (!implicit && tx.state() != null) {
            return CompletableFuture.failedFuture((Throwable)new TransactionException("The operation is attempted for completed transaction"));
        }
        InternalTransaction tx0 = implicit ? this.txManager.begin() : tx;
        Int2ObjectOpenHashMap<List<BinaryRow>> keyRowsByPartition = this.mapRowsToPartitions(keyRows);
        CompletableFuture[] futures = new CompletableFuture[keyRowsByPartition.size()];
        int batchNum = 0;
        for (Int2ObjectMap.Entry partToRows : keyRowsByPartition.int2ObjectEntrySet()) {
            CompletableFuture fut;
            TablePartitionId partGroupId = new TablePartitionId(this.tableId, partToRows.getIntKey());
            IgniteBiTuple primaryReplicaAndTerm = tx0.enlistedNodeAndTerm((ReplicationGroupId)partGroupId);
            if (primaryReplicaAndTerm != null) {
                TablePartitionId commitPart2 = (TablePartitionId)tx.commitPartition();
                ReplicaRequest request = (ReplicaRequest)op.apply((Object)commitPart2, (Object)((Collection)partToRows.getValue()), (Object)tx0, (Object)partGroupId, (Object)((Long)primaryReplicaAndTerm.get2()));
                try {
                    fut = this.replicaSvc.invoke((ClusterNode)primaryReplicaAndTerm.get1(), request);
                }
                catch (PrimaryReplicaMissException e) {
                    throw new TransactionException((Throwable)e);
                }
                catch (Throwable e) {
                    throw new TransactionException("Failed to invoke the replica request.");
                }
            } else {
                fut = this.enlistWithRetry(tx0, partToRows.getIntKey(), (commitPart, term) -> (ReplicaRequest)op.apply(commitPart, (Object)((Collection)partToRows.getValue()), (Object)tx0, (Object)partGroupId, term), 5);
            }
            futures[batchNum++] = fut;
        }
        CompletableFuture<T> fut = reducer.apply(futures);
        return this.postEnlist(fut, implicit, tx0);
    }

    protected CompletableFuture<Collection<BinaryRow>> enlistCursorInTx(@NotNull InternalTransaction tx, int partId, long scanId, int batchSize, @Nullable UUID indexId, @Nullable BinaryTuple exactKey, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        CompletableFuture fut;
        TablePartitionId partGroupId = new TablePartitionId(this.tableId, partId);
        IgniteBiTuple primaryReplicaAndTerm = tx.enlistedNodeAndTerm((ReplicationGroupId)partGroupId);
        ReadWriteScanRetrieveBatchReplicaRequestBuilder requestBuilder = this.tableMessagesFactory.readWriteScanRetrieveBatchReplicaRequest().groupId(partGroupId).transactionId(tx.id()).scanId(scanId).indexToUse(indexId).exactKey(exactKey).lowerBound(lowerBound).upperBound(upperBound).flags(flags).columnsToInclude(columnsToInclude).batchSize(batchSize).timestamp(this.clock.now());
        if (primaryReplicaAndTerm != null) {
            ReadWriteScanRetrieveBatchReplicaRequest request = requestBuilder.term((Long)primaryReplicaAndTerm.get2()).build();
            try {
                fut = this.replicaSvc.invoke((ClusterNode)primaryReplicaAndTerm.get1(), (ReplicaRequest)request);
            }
            catch (PrimaryReplicaMissException e) {
                throw new TransactionException((Throwable)e);
            }
            catch (Throwable e) {
                throw new TransactionException("Failed to invoke the replica request.");
            }
        } else {
            fut = this.enlistWithRetry(tx, partId, (commitPart, term) -> requestBuilder.term((Long)term).build(), 5);
        }
        return this.postEnlist(fut, false, tx);
    }

    private <R> CompletableFuture<R> enlistWithRetry(InternalTransaction tx, int partId, BiFunction<TablePartitionId, Long, ReplicaRequest> requestFunction, int attempts) {
        CompletableFuture result = new CompletableFuture();
        ((CompletableFuture)this.enlist(partId, tx).thenCompose(primaryReplicaAndTerm -> {
            try {
                return this.replicaSvc.invoke((ClusterNode)primaryReplicaAndTerm.get1(), (ReplicaRequest)requestFunction.apply((TablePartitionId)tx.commitPartition(), (Long)primaryReplicaAndTerm.get2()));
            }
            catch (PrimaryReplicaMissException e) {
                throw new TransactionException((Throwable)e);
            }
            catch (Throwable e) {
                throw new TransactionException(IgniteStringFormatter.format((String)"Failed to enlist partition[tableName={}, partId={}] into a transaction", (Object[])new Object[]{this.tableName, partId}));
            }
        })).handle((res0, e) -> {
            if (e != null) {
                if (e.getCause() instanceof PrimaryReplicaMissException && attempts > 0) {
                    return this.enlistWithRetry(tx, partId, requestFunction, attempts - 1).handle((r2, e2) -> {
                        if (e2 != null) {
                            return result.completeExceptionally((Throwable)e2);
                        }
                        return result.complete(r2);
                    });
                }
                return result.completeExceptionally((Throwable)e);
            }
            return result.complete(res0);
        });
        return result;
    }

    private <T> CompletableFuture<T> postEnlist(final CompletableFuture<T> fut, final boolean implicit, final InternalTransaction tx0) {
        return ((CompletableFuture)fut.handle(new BiFunction<T, Throwable, CompletableFuture<T>>(){

            @Override
            public CompletableFuture<T> apply(T r, Throwable e) {
                if (e != null) {
                    return tx0.rollbackAsync().handle((ignored, err) -> {
                        if (err != null) {
                            e.addSuppressed((Throwable)err);
                        }
                        throw (RuntimeException)e;
                    });
                }
                tx0.enlistResultFuture(fut);
                return implicit ? tx0.commitAsync().thenApply(ignored -> r) : CompletableFuture.completedFuture(r);
            }
        })).thenCompose(x -> x);
    }

    @Override
    public CompletableFuture<BinaryRow> get(BinaryRowEx keyRow, InternalTransaction tx) {
        if (tx != null && tx.isReadOnly()) {
            return this.evaluateReadOnlyRecipientNode(this.partId(keyRow)).thenCompose(recipientNode -> this.get(keyRow, tx.readTimestamp(), (ClusterNode)recipientNode));
        }
        return this.enlistInTx(keyRow, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).binaryRow((BinaryRow)keyRow).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_GET).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<BinaryRow> get(BinaryRowEx keyRow, @NotNull HybridTimestamp readTimestamp, @NotNull ClusterNode recipientNode) {
        int partId = this.partId(keyRow);
        ReplicationGroupId partGroupId = ((RaftGroupService)this.partitionMap.get(partId)).groupId();
        return this.replicaSvc.invoke(recipientNode, (ReplicaRequest)this.tableMessagesFactory.readOnlySingleRowReplicaRequest().groupId(partGroupId).binaryRow((BinaryRow)keyRow).requestType(RequestType.RO_GET).readTimestamp(readTimestamp).build());
    }

    @Override
    public CompletableFuture<Collection<BinaryRow>> getAll(Collection<BinaryRowEx> keyRows, InternalTransaction tx) {
        if (tx != null && tx.isReadOnly()) {
            BinaryRowEx firstRow = keyRows.iterator().next();
            if (firstRow == null) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return this.evaluateReadOnlyRecipientNode(this.partId(firstRow)).thenCompose(recipientNode -> this.getAll(keyRows, tx.readTimestamp(), (ClusterNode)recipientNode));
        }
        return this.enlistInTx(keyRows, tx, (IgniteFiveFunction<TablePartitionId, Collection<BinaryRow>, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteFiveFunction)(commitPart, keyRows0, txo, groupId, term) -> this.tableMessagesFactory.readWriteMultiRowReplicaRequest().groupId((ReplicationGroupId)groupId).binaryRows((Collection<BinaryRow>)keyRows0).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_GET_ALL).timestamp(this.clock.now()).build()), this::collectMultiRowsResponses);
    }

    @Override
    public CompletableFuture<Collection<BinaryRow>> getAll(Collection<BinaryRowEx> keyRows, @NotNull HybridTimestamp readTimestamp, @NotNull ClusterNode recipientNode) {
        Int2ObjectOpenHashMap<List<BinaryRow>> keyRowsByPartition = this.mapRowsToPartitions(keyRows);
        CompletableFuture[] futures = new CompletableFuture[keyRowsByPartition.size()];
        int batchNum = 0;
        for (Int2ObjectMap.Entry partToRows : keyRowsByPartition.int2ObjectEntrySet()) {
            ReplicationGroupId partGroupId = ((RaftGroupService)this.partitionMap.get(partToRows.getIntKey())).groupId();
            CompletableFuture fut = this.replicaSvc.invoke(recipientNode, (ReplicaRequest)this.tableMessagesFactory.readOnlyMultiRowReplicaRequest().groupId(partGroupId).binaryRows((Collection)partToRows.getValue()).requestType(RequestType.RO_GET_ALL).readTimestamp(readTimestamp).build());
            futures[batchNum++] = fut;
        }
        return this.collectMultiRowsResponses(futures);
    }

    @Override
    public CompletableFuture<Void> upsert(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)row).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_UPSERT).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Void> upsertAll(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgniteFiveFunction<TablePartitionId, Collection<BinaryRow>, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteFiveFunction)(commitPart, keyRows0, txo, groupId, term) -> this.tableMessagesFactory.readWriteMultiRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRows((Collection<BinaryRow>)keyRows0).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_UPSERT_ALL).timestamp(this.clock.now()).build()), CompletableFuture::allOf);
    }

    @Override
    public CompletableFuture<BinaryRow> getAndUpsert(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)row).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_GET_AND_UPSERT).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Boolean> insert(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)row).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_INSERT).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Collection<BinaryRow>> insertAll(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgniteFiveFunction<TablePartitionId, Collection<BinaryRow>, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteFiveFunction)(commitPart, keyRows0, txo, groupId, term) -> this.tableMessagesFactory.readWriteMultiRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRows((Collection<BinaryRow>)keyRows0).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_INSERT_ALL).timestamp(this.clock.now()).build()), this::collectMultiRowsResponses);
    }

    @Override
    public CompletableFuture<Boolean> replace(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)row).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_REPLACE_IF_EXIST).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Boolean> replace(BinaryRowEx oldRow, BinaryRowEx newRow, InternalTransaction tx) {
        return this.enlistInTx(newRow, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSwapRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).oldBinaryRow((BinaryRow)oldRow).binaryRow((BinaryRow)newRow).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_REPLACE).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<BinaryRow> getAndReplace(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)row).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_GET_AND_REPLACE).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Boolean> delete(BinaryRowEx keyRow, InternalTransaction tx) {
        return this.enlistInTx(keyRow, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)keyRow).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_DELETE).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Boolean> deleteExact(BinaryRowEx oldRow, InternalTransaction tx) {
        return this.enlistInTx(oldRow, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)oldRow).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_DELETE_EXACT).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<BinaryRow> getAndDelete(BinaryRowEx row, InternalTransaction tx) {
        return this.enlistInTx(row, tx, (IgniteTetraFunction<TablePartitionId, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteTetraFunction)(commitPart, txo, groupId, term) -> this.tableMessagesFactory.readWriteSingleRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRow((BinaryRow)row).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_GET_AND_DELETE).timestamp(this.clock.now()).build()));
    }

    @Override
    public CompletableFuture<Collection<BinaryRow>> deleteAll(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgniteFiveFunction<TablePartitionId, Collection<BinaryRow>, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteFiveFunction)(commitPart, keyRows0, txo, groupId, term) -> this.tableMessagesFactory.readWriteMultiRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRows((Collection<BinaryRow>)keyRows0).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_DELETE_ALL).timestamp(this.clock.now()).build()), this::collectMultiRowsResponses);
    }

    @Override
    public CompletableFuture<Collection<BinaryRow>> deleteAllExact(Collection<BinaryRowEx> rows, InternalTransaction tx) {
        return this.enlistInTx(rows, tx, (IgniteFiveFunction<TablePartitionId, Collection<BinaryRow>, InternalTransaction, ReplicationGroupId, Long, ReplicaRequest>)((IgniteFiveFunction)(commitPart, keyRows0, txo, groupId, term) -> this.tableMessagesFactory.readWriteMultiRowReplicaRequest().groupId((ReplicationGroupId)groupId).commitPartitionId((TablePartitionId)commitPart).binaryRows((Collection<BinaryRow>)keyRows0).transactionId(txo.id()).term((Long)term).requestType(RequestType.RW_DELETE_EXACT_ALL).timestamp(this.clock.now()).build()), this::collectMultiRowsResponses);
    }

    @Override
    public Flow.Publisher<BinaryRow> lookup(int partId, @NotNull HybridTimestamp readTimestamp, @NotNull ClusterNode recipientNode, @NotNull UUID indexId, BinaryTuple key, @Nullable BitSet columnsToInclude) {
        return this.scan(partId, readTimestamp, recipientNode, indexId, key, null, null, 0, columnsToInclude);
    }

    @Override
    public Flow.Publisher<BinaryRow> lookup(int partId, @Nullable InternalTransaction tx, @NotNull UUID indexId, BinaryTuple key, @Nullable BitSet columnsToInclude) {
        return this.scan(partId, tx, indexId, key, null, null, 0, columnsToInclude);
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, @NotNull HybridTimestamp readTimestamp, @NotNull ClusterNode recipientNode, @Nullable UUID indexId, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        return this.scan(partId, readTimestamp, recipientNode, indexId, null, lowerBound, upperBound, flags, columnsToInclude);
    }

    private Flow.Publisher<BinaryRow> scan(int partId, @NotNull HybridTimestamp readTimestamp, @NotNull ClusterNode recipientNode, @Nullable UUID indexId, @Nullable BinaryTuple exactKey, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        this.validatePartitionIndex(partId);
        UUID txId = UUID.randomUUID();
        return new PartitionScanPublisher((scanId, batchSize) -> {
            ReplicationGroupId partGroupId = ((RaftGroupService)this.partitionMap.get(partId)).groupId();
            ReadOnlyScanRetrieveBatchReplicaRequest request = this.tableMessagesFactory.readOnlyScanRetrieveBatchReplicaRequest().groupId(partGroupId).readTimestamp(readTimestamp).transactionId(txId).scanId((long)scanId).batchSize((int)batchSize).indexToUse(indexId).exactKey(exactKey).lowerBound(lowerBound).upperBound(upperBound).flags(flags).columnsToInclude(columnsToInclude).build();
            return this.replicaSvc.invoke(recipientNode, (ReplicaRequest)request);
        }, Function.identity());
    }

    @Override
    public Flow.Publisher<BinaryRow> scan(int partId, @Nullable InternalTransaction tx, @Nullable UUID indexId, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        return this.scan(partId, tx, indexId, null, lowerBound, upperBound, flags, columnsToInclude);
    }

    private Flow.Publisher<BinaryRow> scan(int partId, @Nullable InternalTransaction tx, @Nullable UUID indexId, @Nullable BinaryTuple exactKey, @Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, @Nullable BitSet columnsToInclude) {
        if (tx != null && tx.isReadOnly()) {
            throw new TransactionException((Throwable)new TransactionException(ErrorGroups.Transactions.TX_INSUFFICIENT_READ_WRITE_OPERATION_ERR, "Failed to enlist read-write operation into read-only transaction txId={" + tx.id() + "}"));
        }
        this.validatePartitionIndex(partId);
        boolean implicit = tx == null;
        InternalTransaction tx0 = implicit ? this.txManager.begin() : tx;
        return new PartitionScanPublisher((scanId, batchSize) -> this.enlistCursorInTx(tx0, partId, (long)scanId, (int)batchSize, indexId, exactKey, lowerBound, upperBound, flags, columnsToInclude), fut -> this.postEnlist((CompletableFuture)fut, implicit, tx0));
    }

    private void validatePartitionIndex(int p) {
        if (p < 0 || p >= this.partitions) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Invalid partition [partition={}, minValue={}, maxValue={}].", (Object[])new Object[]{p, 0, this.partitions - 1}));
        }
    }

    private Int2ObjectOpenHashMap<List<BinaryRow>> mapRowsToPartitions(Collection<BinaryRowEx> rows) {
        Int2ObjectOpenHashMap keyRowsByPartition = new Int2ObjectOpenHashMap();
        for (BinaryRowEx keyRow : rows) {
            ((List)keyRowsByPartition.computeIfAbsent(this.partId(keyRow), k -> new ArrayList())).add(keyRow);
        }
        return keyRowsByPartition;
    }

    @Override
    public List<String> assignments() {
        this.awaitLeaderInitialization();
        return this.partitionMap.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue).map(RaftGroupService::leader).map(Peer::address).map(this.netAddrResolver).collect(Collectors.toList());
    }

    @Override
    public ClusterNode leaderAssignment(int partition) {
        this.awaitLeaderInitialization();
        RaftGroupService raftGroupService = (RaftGroupService)this.partitionMap.get(partition);
        if (raftGroupService == null) {
            throw new IgniteInternalException("No such partition " + partition + " in table " + this.tableName);
        }
        return this.clusterNodeResolver.apply(raftGroupService.leader().address());
    }

    @Override
    public RaftGroupService partitionRaftGroupService(int partition) {
        RaftGroupService raftGroupService = (RaftGroupService)this.partitionMap.get(partition);
        if (raftGroupService == null) {
            throw new IgniteInternalException("No such partition " + partition + " in table " + this.tableName);
        }
        if (raftGroupService.leader() == null) {
            raftGroupService.refreshLeader().join();
        }
        return raftGroupService;
    }

    @Override
    public TxStateTableStorage txStateStorage() {
        return this.txStateStorage;
    }

    private void awaitLeaderInitialization() {
        ArrayList<CompletableFuture> futs = new ArrayList<CompletableFuture>();
        for (RaftGroupService raftSvc : this.partitionMap.values()) {
            if (raftSvc.leader() != null) continue;
            futs.add(raftSvc.refreshLeader());
        }
        CompletableFuture.allOf((CompletableFuture[])futs.toArray(CompletableFuture[]::new)).join();
    }

    @Override
    @TestOnly
    public int partition(BinaryRowEx keyRow) {
        return this.partId(keyRow);
    }

    private int partId(BinaryRowEx row) {
        int partId = row.colocationHash() % this.partitions;
        return partId < 0 ? -partId : partId;
    }

    private CompletableFuture<Collection<BinaryRow>> collectMultiRowsResponses(CompletableFuture<Object>[] futs) {
        return CompletableFuture.allOf(futs).thenApply(response -> {
            ArrayList list = new ArrayList(futs.length);
            for (CompletableFuture future : futs) {
                Collection values = (Collection)future.join();
                if (values == null) continue;
                list.addAll(values);
            }
            return list;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInternalTableRaftGroupService(int p, RaftGroupService raftGrpSvc) {
        RaftGroupService oldSrvc;
        Object object = this.updatePartMapMux;
        synchronized (object) {
            oldSrvc = (RaftGroupService)this.partitionMap.put(p, (Object)raftGrpSvc);
        }
        if (oldSrvc != null) {
            oldSrvc.shutdown();
        }
    }

    protected CompletableFuture<IgniteBiTuple<ClusterNode, Long>> enlist(int partId, InternalTransaction tx) {
        RaftGroupService svc = (RaftGroupService)this.partitionMap.get(partId);
        tx.assignCommitPartition((ReplicationGroupId)new TablePartitionId(this.tableId, partId));
        CompletableFuture fut0 = svc.refreshAndGetLeaderWithTerm();
        return fut0.handle((primaryPeerAndTerm, e) -> {
            if (primaryPeerAndTerm.get1() == null || e != null) {
                throw new TransactionException("Failed to get the primary replica.");
            }
            TablePartitionId partGroupId = new TablePartitionId(this.tableId, partId);
            return tx.enlist((ReplicationGroupId)partGroupId, new IgniteBiTuple((Object)this.clusterNodeResolver.apply(((Peer)primaryPeerAndTerm.get1()).address()), (Object)((Long)primaryPeerAndTerm.get2())));
        });
    }

    @Override
    public void close() throws Exception {
        for (RaftGroupService srv : this.partitionMap.values()) {
            srv.shutdown();
        }
    }

    protected CompletableFuture<ClusterNode> evaluateReadOnlyRecipientNode(int partId) {
        RaftGroupService svc = (RaftGroupService)this.partitionMap.get(partId);
        return svc.refreshAndGetLeaderWithTerm().handle((res, e) -> {
            if (e != null) {
                throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (Throwable)e);
            }
            if (res == null || res.getKey() == null) {
                throw (TransactionException)ExceptionUtils.withCause(TransactionException::new, (int)ErrorGroups.Replicator.REPLICA_UNAVAILABLE_ERR, (Throwable)e);
            }
            return this.clusterNodeResolver.apply(((Peer)res.get1()).address());
        });
    }

    private static class PartitionScanPublisher
    implements Flow.Publisher<BinaryRow> {
        private final BiFunction<Long, Integer, CompletableFuture<Collection<BinaryRow>>> retrieveBatch;
        Function<CompletableFuture<Void>, CompletableFuture<Void>> onClose;
        private AtomicBoolean subscribed;

        PartitionScanPublisher(BiFunction<Long, Integer, CompletableFuture<Collection<BinaryRow>>> retrieveBatch, Function<CompletableFuture<Void>, CompletableFuture<Void>> onClose) {
            this.retrieveBatch = retrieveBatch;
            this.onClose = onClose;
            this.subscribed = new AtomicBoolean(false);
        }

        @Override
        public void subscribe(Flow.Subscriber<? super BinaryRow> subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("Subscriber is null");
            }
            if (!this.subscribed.compareAndSet(false, true)) {
                subscriber.onError(new IllegalStateException("Scan publisher does not support multiple subscriptions."));
            }
            PartitionScanSubscription subscription = new PartitionScanSubscription(subscriber);
            subscriber.onSubscribe(subscription);
        }

        private class PartitionScanSubscription
        implements Flow.Subscription {
            private final Flow.Subscriber<? super BinaryRow> subscriber;
            private final AtomicBoolean canceled;
            private final Long scanId;
            private final AtomicLong requestedItemsCnt;
            private static final int INTERNAL_BATCH_SIZE = 10000;

            private PartitionScanSubscription(Flow.Subscriber<? super BinaryRow> subscriber) {
                this.subscriber = subscriber;
                this.canceled = new AtomicBoolean(false);
                this.scanId = CURSOR_ID_GENERATOR.getAndIncrement();
                this.requestedItemsCnt = new AtomicLong(0L);
            }

            @Override
            public void request(long n) {
                if (n <= 0L) {
                    this.cancel();
                    this.subscriber.onError(new IllegalArgumentException(IgniteStringFormatter.format((String)"Invalid requested amount of items [requested={}, minValue=1]", (Object[])new Object[]{n})));
                }
                if (this.canceled.get()) {
                    return;
                }
                long prevVal = this.requestedItemsCnt.getAndUpdate(origin -> {
                    try {
                        return Math.addExact(origin, n);
                    }
                    catch (ArithmeticException e) {
                        return Long.MAX_VALUE;
                    }
                });
                if (prevVal == 0L) {
                    this.scanBatch((int)Math.min(n, 10000L));
                }
            }

            @Override
            public void cancel() {
                this.cancel(null);
            }

            public void cancel(Throwable t) {
                if (!this.canceled.compareAndSet(false, true)) {
                    return;
                }
                PartitionScanPublisher.this.onClose.apply(t == null ? CompletableFuture.completedFuture(null) : CompletableFuture.failedFuture(t)).handle((ignore, th) -> {
                    if (th != null) {
                        this.subscriber.onError((Throwable)th);
                    } else {
                        this.subscriber.onComplete();
                    }
                    return null;
                });
            }

            private void scanBatch(int n) {
                if (this.canceled.get()) {
                    return;
                }
                ((CompletableFuture)PartitionScanPublisher.this.retrieveBatch.apply(this.scanId, n).thenAccept(binaryRows -> {
                    if (binaryRows == null) {
                        this.cancel();
                        return;
                    }
                    binaryRows.forEach(this.subscriber::onNext);
                    if (binaryRows.size() < n) {
                        this.cancel();
                    } else if (this.requestedItemsCnt.addAndGet(Math.negateExact(binaryRows.size())) > 0L) {
                        this.scanBatch(Math.min(n, 10000));
                    }
                })).exceptionally(t -> {
                    this.cancel((Throwable)t);
                    return null;
                });
            }
        }
    }
}

