/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.tx.IgniteTransactions;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

public class ClientTransactions
implements IgniteTransactions {
    private final ReliableChannel ch;

    public ClientTransactions(ReliableChannel ch) {
        this.ch = ch;
    }

    public Transaction begin(@Nullable TransactionOptions options) {
        return (Transaction)ViewUtils.sync(this.beginAsync(options));
    }

    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        return CompletableFuture.completedFuture(new ClientLazyTransaction(this.ch.observableTimestamp(), options));
    }

    static CompletableFuture<ClientTransaction> beginAsync(ReliableChannel ch, @Nullable String preferredNodeName, @Nullable TransactionOptions options, long observableTimestamp) {
        if (options != null && options.timeoutMillis() != 0L && !options.readOnly()) {
            throw new UnsupportedOperationException("Timeouts are not supported yet for RW transactions");
        }
        boolean readOnly = options != null && options.readOnly();
        return ch.serviceAsync(43, w -> {
            w.out().packBoolean(readOnly);
            w.out().packLong(options == null ? 0L : options.timeoutMillis());
            w.out().packLong(observableTimestamp);
        }, r -> ClientTransactions.readTx(r, readOnly), preferredNodeName, null, false);
    }

    private static ClientTransaction readTx(PayloadInputChannel r, boolean isReadOnly) {
        ClientMessageUnpacker in = r.in();
        long id = in.unpackLong();
        return new ClientTransaction(r.clientChannel(), id, isReadOnly);
    }
}

