/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelFactories;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;

public enum EnumerableConvention implements Convention
{
    INSTANCE;

    public static final double COST_MULTIPLIER = 1.0;

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Class getInterface() {
        return EnumerableRel.class;
    }

    @Override
    public String getName() {
        return "ENUMERABLE";
    }

    @Override
    public RelNode enforce(RelNode input, RelTraitSet required) {
        Object collation;
        RelNode rel = input;
        if (input.getConvention() != INSTANCE) {
            rel = ConventionTraitDef.INSTANCE.convert(input.getCluster().getPlanner(), input, INSTANCE, true);
            Objects.requireNonNull(rel, () -> "Unable to convert input to " + INSTANCE + ", input = " + input);
        }
        if ((collation = required.getCollation()) != null && collation != RelCollations.EMPTY) {
            rel = EnumerableSort.create(rel, collation, null, null);
        }
        return rel;
    }

    @Override
    public RelTraitDef getTraitDef() {
        return ConventionTraitDef.INSTANCE;
    }

    @Override
    public boolean satisfies(RelTrait trait) {
        return this == trait;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean canConvertConvention(Convention toConvention) {
        return false;
    }

    @Override
    public boolean useAbstractConvertersForConversion(RelTraitSet fromTraits, RelTraitSet toTraits) {
        return true;
    }

    @Override
    public RelFactories.Struct getRelFactories() {
        return RelFactories.Struct.fromContext(Contexts.of(EnumerableRelFactories.ENUMERABLE_TABLE_SCAN_FACTORY, EnumerableRelFactories.ENUMERABLE_PROJECT_FACTORY, EnumerableRelFactories.ENUMERABLE_FILTER_FACTORY, EnumerableRelFactories.ENUMERABLE_SORT_FACTORY));
    }
}

