/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.util.Arrays;
import java.util.List;
import mil.nga.geopackage.dgiwg.DGIWGGeoPackageUtils;
import mil.nga.geopackage.dgiwg.DGIWGRequirement;
import mil.nga.geopackage.dgiwg.DGIWGValidationKey;

public class DGIWGValidationError {
    private String table = null;
    private String column = null;
    private String value = null;
    private String constraint = null;
    private DGIWGRequirement requirement = null;
    private List<DGIWGValidationKey> primaryKeys = null;

    public DGIWGValidationError(String table, String column, String value, String constraint, DGIWGRequirement requirement) {
        this(table, value, constraint, requirement);
        this.column = column;
    }

    public DGIWGValidationError(String table, String column, Number value, String constraint, DGIWGRequirement requirement) {
        this(table, column, value != null ? value.toString() : null, constraint, requirement);
    }

    public DGIWGValidationError(String table, String column, Number value, Number constraint, DGIWGRequirement requirement) {
        this(table, column, value, constraint != null ? constraint.toString() : null, requirement);
    }

    public DGIWGValidationError(String table, String value, String constraint, DGIWGRequirement requirement) {
        this(value, constraint, requirement);
        this.table = table;
    }

    public DGIWGValidationError(String value, String constraint, DGIWGRequirement requirement) {
        this(constraint, requirement);
        this.value = value;
    }

    public DGIWGValidationError(String constraint, DGIWGRequirement requirement) {
        this.constraint = constraint;
        this.requirement = requirement;
    }

    public DGIWGValidationError(String table, String value, String constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, null, value, constraint, requirement, primaryKeys);
    }

    public DGIWGValidationError(String table, String column, String value, String constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, column, value, constraint, requirement);
        if (primaryKeys != null && primaryKeys.length > 0 && primaryKeys[0] != null) {
            this.primaryKeys = Arrays.asList(primaryKeys);
        }
    }

    public DGIWGValidationError(String table, String column, Number value, String constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, column, value != null ? value.toString() : null, constraint, requirement, primaryKeys);
    }

    public DGIWGValidationError(String table, String column, Number value, Number constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, column, value, constraint != null ? constraint.toString() : null, requirement, primaryKeys);
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getValue() {
        return this.value;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public DGIWGRequirement getRequirement() {
        return this.requirement;
    }

    public List<DGIWGValidationKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        if (this.table != null) {
            toString.append("Table: ").append(this.table);
        }
        if (this.column != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Column: ").append(this.column);
        }
        if (this.value != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Value: ").append(DGIWGGeoPackageUtils.wrapIfEmptyOrContainsWhitespace(this.value));
        }
        if (this.primaryKeys != null) {
            for (DGIWGValidationKey key : this.primaryKeys) {
                if (key.getColumn().equalsIgnoreCase(this.column)) continue;
                if (toString.length() > 0) {
                    toString.append(", ");
                }
                toString.append("PK: [").append(key).append("]");
            }
        }
        if (this.constraint != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Constraint: ").append(DGIWGGeoPackageUtils.wrapIfEmptyOrContainsWhitespace(this.constraint));
        }
        if (this.requirement != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Requirement: [").append((Object)this.requirement).append("]");
        }
        return toString.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + (this.constraint == null ? 0 : this.constraint.hashCode());
        result = 31 * result + (this.primaryKeys == null ? 0 : this.primaryKeys.hashCode());
        result = 31 * result + (this.requirement == null ? 0 : this.requirement.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DGIWGValidationError other = (DGIWGValidationError)obj;
        if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
            return false;
        }
        if (this.constraint == null ? other.constraint != null : !this.constraint.equals(other.constraint)) {
            return false;
        }
        if (this.primaryKeys == null ? other.primaryKeys != null : !this.primaryKeys.equals(other.primaryKeys)) {
            return false;
        }
        if (this.requirement != other.requirement) {
            return false;
        }
        if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

