/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.xml.Namespaces;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformedEvent;
import org.apache.sis.xml.Transformer;

final class TransformingReader
extends Transformer
implements XMLEventReader {
    static final String FILENAME = "RenameOnImport.lst";
    private static final Set<String> LEGACY_NAMESPACES = new HashSet<String>(12);
    private static final Map<String, Map<String, String>> NAMESPACES = TransformingReader.load(false, "RenameOnImport.lst", LEGACY_NAMESPACES, 260);
    private final XMLEventReader in;
    private final Map<String, String> prefixes;
    private XMLEvent nextEvent;

    static String namespace(String type) {
        Map<String, String> attributes = NAMESPACES.get(type);
        return attributes != null ? attributes.get(type) : null;
    }

    TransformingReader(XMLEventReader in, TransformVersion version) {
        super(version);
        this.in = in;
        this.prefixes = new HashMap<String, String>();
    }

    private static boolean isWrapper(XMLEvent event, XMLEvent wrapper) {
        return event == wrapper || wrapper instanceof TransformedEvent && ((TransformedEvent)wrapper).event == event;
    }

    @Override
    public boolean hasNext() {
        return this.nextEvent != null || this.in.hasNext();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent event;
        if (this.nextEvent == null && (event = this.in.peek()) != null) {
            this.nextEvent = this.convert(event);
        }
        return this.nextEvent;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new BackingStoreException((Throwable)e);
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent event = this.in.nextEvent();
        XMLEvent next = this.nextEvent;
        if (next != null) {
            this.nextEvent = null;
            assert (TransformingReader.isWrapper(event, next)) : event;
            return next;
        }
        return this.convert(event);
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent event = this.in.nextTag();
        XMLEvent next = this.nextEvent;
        if (next != null) {
            this.nextEvent = null;
            switch (event.getEventType()) {
                case 1: 
                case 2: {
                    assert (TransformingReader.isWrapper(event, next)) : event;
                    return event;
                }
            }
        }
        return this.convert(event);
    }

    private XMLEvent convert(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 10: {
                event = this.convert((Attribute)event);
                break;
            }
            case 13: {
                event = this.importNS((Namespace)event, null, null);
                break;
            }
            case 1: {
                StartElement e = event.asStartElement();
                QName originalName = e.getName();
                this.open(originalName);
                QName name = this.convert(originalName);
                boolean changed = name != originalName;
                Namespace localNS = null;
                Iterator<Attribute> it = e.getAttributes();
                while (it.hasNext()) {
                    Attribute a = it.next();
                    Attribute ae = this.convert(a);
                    this.renamedAttributes.add(ae);
                    if (a == ae) continue;
                    changed = true;
                    if (localNS != null || !(ae instanceof TransformedEvent.Type)) continue;
                    localNS = ((TransformedEvent.Type)ae).namespace;
                }
                List<Namespace> namespaces = this.importNS(e.getNamespaces(), originalName.getNamespaceURI(), name.getNamespaceURI(), changed);
                if (namespaces != null) {
                    if (localNS != null) {
                        if (namespaces.isEmpty()) {
                            namespaces = List.of(localNS);
                        } else {
                            namespaces.add(localNS);
                        }
                    }
                    event = new TransformedEvent.Start(e, name, namespaces, this.attributes(), this.version);
                    break;
                }
                this.renamedAttributes.clear();
                break;
            }
            case 2: {
                EndElement e = event.asEndElement();
                QName originalName = e.getName();
                QName name = this.convert(originalName);
                List<Namespace> namespaces = this.importNS(e.getNamespaces(), originalName.getNamespaceURI(), name.getNamespaceURI(), name != originalName);
                if (namespaces != null) {
                    event = new TransformedEvent.End(e, name, namespaces);
                }
                this.close(originalName);
                break;
            }
        }
        return event;
    }

    @Override
    final Map<String, Map<String, String>> renamingMap(String namespace) {
        if (!namespace.isEmpty() && LEGACY_NAMESPACES.contains(TransformingReader.removeTrailingSlash(namespace))) {
            return NAMESPACES;
        }
        return Collections.emptyMap();
    }

    @Override
    final String relocate(String namespace) {
        return this.version.importNS(namespace);
    }

    @Override
    final String prefixReplacement(String previous, String namespace) {
        return this.prefixes.computeIfAbsent(namespace, ns -> Namespaces.getPreferredPrefix(ns, previous));
    }

    private Namespace importNS(Namespace namespace, String oldURI, String newURI) {
        this.notify(namespace);
        String uri = namespace.getNamespaceURI();
        if (uri != null && !uri.isEmpty()) {
            String imported;
            String string = imported = (uri = TransformingReader.removeTrailingSlash(uri)).equals(oldURI) ? newURI : this.relocate(uri);
            if (imported != uri) {
                String prefix = this.prefixReplacement(namespace.getPrefix(), imported);
                return new TransformedEvent.NS(namespace, prefix, imported);
            }
        }
        return namespace;
    }

    private List<Namespace> importNS(Iterator<Namespace> namespaces, String oldURI, String newURI, boolean changed) {
        if (!namespaces.hasNext()) {
            return changed ? List.of() : null;
        }
        ArrayList<Namespace> modified = new ArrayList<Namespace>();
        do {
            Namespace namespace;
            changed |= (namespace = namespaces.next()) != (namespace = this.importNS(namespace, oldURI, newURI));
            modified.add(namespace);
        } while (namespaces.hasNext());
        return changed ? modified : null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.in.getElementText();
    }

    @Override
    public Object getProperty(String name) {
        return this.in.getProperty(name);
    }

    @Override
    public void close() throws XMLStreamException {
        super.close();
        this.in.close();
    }
}

