/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UpdateTopicCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=SetTopicPropertyRequest.class, name="setProperty"), @JsonSubTypes.Type(value=RemoveTopicPropertyRequest.class, name="removeProperty")})
public interface TopicUpdateRequest
extends RESTRequest {
    public TopicChange topicChange();

    public static class RemoveTopicPropertyRequest
    implements TopicUpdateRequest {
        @JsonProperty(value="property")
        private final String property;

        public RemoveTopicPropertyRequest(String property) {
            this.property = property;
        }

        public RemoveTopicPropertyRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
        }

        @Override
        public TopicChange topicChange() {
            return TopicChange.removeProperty((String)this.property);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveTopicPropertyRequest)) {
                return false;
            }
            RemoveTopicPropertyRequest other = (RemoveTopicPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RemoveTopicPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "TopicUpdateRequest.RemoveTopicPropertyRequest(property=" + this.getProperty() + ")";
        }

        public String getProperty() {
            return this.property;
        }
    }

    public static class SetTopicPropertyRequest
    implements TopicUpdateRequest {
        @JsonProperty(value="property")
        private final String property;
        @JsonProperty(value="value")
        private final String value;

        public SetTopicPropertyRequest(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public SetTopicPropertyRequest() {
            this(null, null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.property), (Object)"\"property\" field is required and cannot be empty");
            Preconditions.checkArgument((this.value != null ? 1 : 0) != 0, (Object)"\"value\" field is required and cannot be null");
        }

        @Override
        public TopicChange topicChange() {
            return TopicChange.setProperty((String)this.property, (String)this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetTopicPropertyRequest)) {
                return false;
            }
            SetTopicPropertyRequest other = (SetTopicPropertyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetTopicPropertyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "TopicUpdateRequest.SetTopicPropertyRequest(property=" + this.getProperty() + ", value=" + this.getValue() + ")";
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UpdateTopicCommentRequest
    implements TopicUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdateTopicCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        public UpdateTopicCommentRequest() {
            this(null);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newComment), (Object)"\"newComment\" field is required and cannot be empty");
        }

        @Override
        public TopicChange topicChange() {
            return TopicChange.updateComment((String)this.newComment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTopicCommentRequest)) {
                return false;
            }
            UpdateTopicCommentRequest other = (UpdateTopicCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateTopicCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "TopicUpdateRequest.UpdateTopicCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }
}

