/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;

public class TableEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The table's unique identifier");
    public static final Field NAME = Field.required("name", String.class, "The table's name");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the table");
    private Long id;
    private String name;
    private AuditInfo auditInfo;
    private Namespace namespace;

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(AUDIT_INFO, this.auditInfo);
        return fields;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.TABLE;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableEntity)) {
            return false;
        }
        TableEntity baseTable = (TableEntity)o;
        return Objects.equal((Object)this.id, (Object)baseTable.id) && Objects.equal((Object)this.name, (Object)baseTable.name) && Objects.equal((Object)this.namespace, (Object)baseTable.namespace) && Objects.equal((Object)this.auditInfo, (Object)baseTable.auditInfo);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.auditInfo});
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "TableEntity(id=" + this.id + ", name=" + this.name + ", auditInfo=" + this.auditInfo + ", namespace=" + this.namespace + ")";
    }

    public static class Builder {
        private final TableEntity tableEntity = new TableEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.tableEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.tableEntity.name = name;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.tableEntity.auditInfo = auditInfo;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.tableEntity.namespace = namespace;
            return this;
        }

        public TableEntity build() {
            this.tableEntity.validate();
            return this.tableEntity;
        }
    }
}

