/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg;

import java.util.Map;
import javax.servlet.Servlet;
import org.apache.gravitino.Config;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.auxiliary.GravitinoAuxiliaryService;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.ops.IcebergTableOps;
import org.apache.gravitino.iceberg.service.IcebergExceptionMapper;
import org.apache.gravitino.iceberg.service.IcebergObjectMapperProvider;
import org.apache.gravitino.iceberg.service.metrics.IcebergMetricsManager;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.server.web.HttpServerMetricsSource;
import org.apache.gravitino.server.web.JettyServer;
import org.apache.gravitino.server.web.JettyServerConfig;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTService
implements GravitinoAuxiliaryService {
    private static Logger LOG = LoggerFactory.getLogger(RESTService.class);
    private JettyServer server;
    public static final String SERVICE_NAME = "iceberg-rest";
    public static final String ICEBERG_SPEC = "/iceberg/*";
    private IcebergTableOps icebergTableOps;
    private IcebergMetricsManager icebergMetricsManager;

    private void initServer(IcebergConfig icebergConfig) {
        JettyServerConfig serverConfig = JettyServerConfig.fromConfig((Config)icebergConfig);
        this.server = new JettyServer();
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        this.server.initialize(serverConfig, SERVICE_NAME, false);
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.apache.gravitino.iceberg.service.rest"});
        config.register(IcebergObjectMapperProvider.class).register(JacksonFeature.class);
        config.register(IcebergExceptionMapper.class);
        HttpServerMetricsSource httpServerMetricsSource = new HttpServerMetricsSource("iceberg-rest-server", config, this.server);
        metricsSystem.register((MetricsSource)httpServerMetricsSource);
        this.icebergTableOps = new IcebergTableOps(icebergConfig);
        this.icebergMetricsManager = new IcebergMetricsManager(icebergConfig);
        config.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(RESTService.this.icebergTableOps).to(IcebergTableOps.class).ranked(1);
                this.bind(RESTService.this.icebergMetricsManager).to(IcebergMetricsManager.class).ranked(1);
            }
        });
        ServletContainer servlet = new ServletContainer(config);
        this.server.addServlet((Servlet)servlet, ICEBERG_SPEC);
        this.server.addCustomFilters(ICEBERG_SPEC);
        this.server.addSystemFilters(ICEBERG_SPEC);
    }

    public String shortName() {
        return SERVICE_NAME;
    }

    public void serviceInit(Map<String, String> properties) {
        IcebergConfig icebergConfig = new IcebergConfig(properties);
        this.initServer(icebergConfig);
        LOG.info("Iceberg REST service init.");
    }

    public void serviceStart() {
        this.icebergMetricsManager.start();
        if (this.server != null) {
            try {
                this.server.start();
                LOG.info("Iceberg REST service started");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            LOG.info("Iceberg REST service stopped");
        }
        if (this.icebergTableOps != null) {
            this.icebergTableOps.close();
        }
        if (this.icebergMetricsManager != null) {
            this.icebergMetricsManager.close();
        }
    }

    public void join() {
        if (this.server != null) {
            this.server.join();
        }
    }
}

