/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system.table;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;
import org.apache.gravitino.trino.connector.system.table.GravitinoSystemTable;

public class GravitinoSystemTableCatalog
extends GravitinoSystemTable {
    public static final SchemaTableName TABLE_NAME = new SchemaTableName("system", "catalog");
    private static final ConnectorTableMetadata TABLE_METADATA = new ConnectorTableMetadata(TABLE_NAME, List.of(ColumnMetadata.builder().setName("name").setType((Type)VarcharType.VARCHAR).build(), ColumnMetadata.builder().setName("provider").setType((Type)VarcharType.VARCHAR).build(), ColumnMetadata.builder().setName("properties").setType((Type)VarcharType.VARCHAR).build()));
    private final CatalogConnectorManager catalogConnectorManager;

    public GravitinoSystemTableCatalog(CatalogConnectorManager catalogConnectorManager) {
        this.catalogConnectorManager = catalogConnectorManager;
    }

    @Override
    public Page loadPageData() {
        ArrayList gravitinoCatalogs = new ArrayList();
        this.catalogConnectorManager.getUsedMetalakes().forEach(metalakeName -> {
            Catalog[] catalogs;
            GravitinoMetalake metalake = this.catalogConnectorManager.getMetalake((String)metalakeName);
            for (Catalog catalog : catalogs = metalake.listCatalogsInfo()) {
                if (catalog.type() != Catalog.Type.RELATIONAL) continue;
                gravitinoCatalogs.add(new GravitinoCatalog((String)metalakeName, catalog));
            }
        });
        int size = gravitinoCatalogs.size();
        VariableWidthBlockBuilder nameColumnBuilder = VarcharType.VARCHAR.createBlockBuilder(null, size);
        VariableWidthBlockBuilder providerColumnBuilder = VarcharType.VARCHAR.createBlockBuilder(null, size);
        VariableWidthBlockBuilder propertyColumnBuilder = VarcharType.VARCHAR.createBlockBuilder(null, size);
        for (GravitinoCatalog catalog : gravitinoCatalogs) {
            Preconditions.checkNotNull((Object)catalog, (Object)"catalog should not be null");
            VarcharType.VARCHAR.writeString((BlockBuilder)nameColumnBuilder, catalog.getName());
            VarcharType.VARCHAR.writeString((BlockBuilder)providerColumnBuilder, catalog.getProvider());
            try {
                VarcharType.VARCHAR.writeString((BlockBuilder)propertyColumnBuilder, new ObjectMapper().writeValueAsString(new TreeMap<String, String>(catalog.getProperties())));
            }
            catch (JsonProcessingException e) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Invalid property format", (Throwable)e);
            }
        }
        return new Page(size, new Block[]{nameColumnBuilder.build(), providerColumnBuilder.build(), propertyColumnBuilder.build()});
    }

    @Override
    public ConnectorTableMetadata getTableMetaData() {
        return TABLE_METADATA;
    }
}

