/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class ThreadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtil.class);

    public static void sleepAtLeastIgnoreInterrupts(long millis) {
        long start = Time.now();
        while (Time.now() - start < millis) {
            long timeToSleep = millis - (Time.now() - start);
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie) {
                LOG.warn("interrupted while sleeping", (Throwable)ie);
            }
        }
    }
}

