/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.util;

public class IPAddressParser {
    public static byte[] parseIPv4Literal(String s) {
        s = s != null ? s.trim() : "";
        String[] toks = s.split("\\.");
        byte[] ip = new byte[4];
        if (toks.length == 4) {
            for (int i = 0; i < ip.length; ++i) {
                try {
                    int val = Integer.parseInt(toks[i]);
                    if (val < 0 || val > 255) {
                        return null;
                    }
                    ip[i] = (byte)val;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            return ip;
        }
        return null;
    }

    public static byte[] parseIPv6Literal(String s) {
        String string = s = s != null ? s.trim() : "";
        if (s.length() > 0 && s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
            s = s.substring(1, s.length() - 1).trim();
        }
        int x = s.lastIndexOf(58);
        int y = s.indexOf(46);
        if (x >= 0 && y > x) {
            byte[] ip4Suffix = IPAddressParser.parseIPv4Literal(s.substring(x + 1));
            if (ip4Suffix == null) {
                return null;
            }
            s = s.substring(0, x) + ":" + IPAddressParser.ip4ToHex(ip4Suffix);
        }
        if ((x = s.indexOf("::")) >= 0 && s.indexOf("::", x + 1) >= 0) {
            return null;
        }
        String[] raw = new String[]{"0000", "0000", "0000", "0000", "0000", "0000", "0000", "0000"};
        if (s.indexOf("::") >= 0) {
            String[] suffix;
            String[] split = s.split("::", -1);
            String[] prefix = IPAddressParser.splitOnColon(split[0]);
            if (prefix.length + (suffix = IPAddressParser.splitOnColon(split[1])).length > 7) {
                return null;
            }
            for (int i = 0; i < prefix.length; ++i) {
                raw[i] = IPAddressParser.prependZeroes(prefix[i]);
            }
            int startPos = raw.length - suffix.length;
            for (int i = 0; i < suffix.length; ++i) {
                raw[startPos + i] = IPAddressParser.prependZeroes(suffix[i]);
            }
        } else {
            raw = IPAddressParser.splitOnColon(s);
            if (raw.length != 8) {
                return null;
            }
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = IPAddressParser.prependZeroes(raw[i]);
            }
        }
        byte[] ip6 = new byte[16];
        int i = 0;
        for (String tok : raw) {
            if (tok.length() > 4) {
                return null;
            }
            String prefix = tok.substring(0, 2);
            String suffix = tok.substring(2, 4);
            try {
                ip6[i++] = (byte)Integer.parseInt(prefix, 16);
                ip6[i++] = (byte)Integer.parseInt(suffix, 16);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return ip6;
    }

    private static String prependZeroes(String s) {
        switch (s.length()) {
            case 0: {
                return "0000";
            }
            case 1: {
                return "000" + s;
            }
            case 2: {
                return "00" + s;
            }
            case 3: {
                return "0" + s;
            }
        }
        return s;
    }

    private static String[] splitOnColon(String s) {
        if ("".equals(s)) {
            return new String[0];
        }
        return s.split(":");
    }

    private static String ip4ToHex(byte[] b) {
        return IPAddressParser.b2s(b[0]) + IPAddressParser.b2s(b[1]) + ":" + IPAddressParser.b2s(b[2]) + IPAddressParser.b2s(b[3]);
    }

    private static String b2s(byte b) {
        String s = Integer.toHexString(b >= 0 ? b : 256 + b);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }
}

