/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;

public class PlcList
extends PlcValueAdapter {
    private final List<PlcValue> listItems;

    public PlcList() {
        this.listItems = new ArrayList<PlcValue>();
    }

    public PlcList(List<PlcValue> listItems) {
        this.listItems = listItems.stream().collect(Collectors.toUnmodifiableList());
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.List;
    }

    public void add(PlcValue value) {
        this.listItems.add(value);
    }

    @Override
    public Object getObject() {
        return this.getList();
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public int getLength() {
        return this.listItems.size();
    }

    @Override
    public PlcValue getIndex(int i) {
        return this.listItems.get(i);
    }

    public List<PlcValue> getList() {
        return this.listItems;
    }

    public String toString() {
        return "[" + this.listItems.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcList", new WithWriterArgs[0]);
        for (PlcValue listItem : this.listItems) {
            if (!(listItem instanceof Serializable)) {
                throw new PlcRuntimeException("Error serializing. List item doesn't implement XmlSerializable");
            }
            ((Serializable)listItem).serialize(writeBuffer);
        }
        writeBuffer.popContext("PlcList", new WithWriterArgs[0]);
    }
}

