/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.provider.annotation;

import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.provider.annotation.RequiresRoles;
import com.usthe.sureness.provider.annotation.WithoutAuth;
import com.usthe.sureness.util.ClassScanner;
import com.usthe.sureness.util.SurenessCommonUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationPathTreeProvider
implements PathTreeProvider {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationPathTreeProvider.class);
    private List<String> scanPackages;
    private List<Class<?>> scanClasses;
    private volatile boolean isInit = false;

    private synchronized void init() {
        if (this.scanPackages == null) {
            this.scanPackages = Collections.singletonList(" ");
        }
        this.isInit = true;
        this.scanClasses = ClassScanner.scanPackages(this.scanPackages);
        logger.info("sureness: annotationLoader success init, load {} classes total.", (Object)this.scanClasses.size());
    }

    @Override
    public Set<String> providePathData() {
        if (!this.isInit) {
            this.init();
        }
        HashSet<String> resource = new HashSet<String>();
        for (Class<?> clazz : this.scanClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(WithoutAuth.class) || !method.isAnnotationPresent(RequiresRoles.class)) continue;
                RequiresRoles requiresRoles = method.getDeclaredAnnotation(RequiresRoles.class);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < requiresRoles.roles().length; ++i) {
                    if (i < requiresRoles.roles().length - 1) {
                        builder.append(requiresRoles.roles()[i]).append(",");
                        continue;
                    }
                    builder.append(requiresRoles.roles()[i]);
                }
                String path = requiresRoles.mapping().toLowerCase() + "===" + requiresRoles.method().toLowerCase() + "===[" + builder.toString() + "]";
                resource.add(path);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("sureness: annotationLoader load path {}.", (Object)path);
            }
        }
        return SurenessCommonUtil.attachContextPath(this.getContextPath(), resource);
    }

    @Override
    public Set<String> provideExcludedResource() {
        if (!this.isInit) {
            this.init();
        }
        HashSet<String> resource = new HashSet<String>();
        for (Class<?> clazz : this.scanClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(WithoutAuth.class)) continue;
                WithoutAuth withoutAuth = method.getDeclaredAnnotation(WithoutAuth.class);
                String path = withoutAuth.mapping().toLowerCase() + "===" + withoutAuth.method().toLowerCase();
                resource.add(path);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("sureness: annotationLoader load exclude path {}.", (Object)path);
            }
        }
        return SurenessCommonUtil.attachContextPath(this.getContextPath(), resource);
    }

    public List<String> getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(List<String> scanPackages) {
        this.scanPackages = scanPackages;
    }
}

