/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public abstract class AbstractVariable
implements Variable,
Serializable {
    private static final long serialVersionUID = 1395840752909725320L;
    public static final String SMISYNTAXES_PROPERTIES = "org.snmp4j.smisyntaxes";
    private static final String SMISYNTAXES_PROPERTIES_DEFAULT = "smisyntaxes.properties";
    private static final Object[][] SYNTAX_NAME_MAPPING = new Object[][]{{"Integer32", 2}, {"BIT STRING", 3}, {"OCTET STRING", 4}, {"OBJECT IDENTIFIER", 6}, {"TimeTicks", 67}, {"Counter", 65}, {"Counter64", 70}, {"EndOfMibView", 130}, {"Gauge", 66}, {"Unsigned32", 66}, {"IpAddress", 64}, {"NoSuchInstance", 129}, {"NoSuchObject", 128}, {"Null", 5}, {"Opaque", 68}};
    private static Hashtable<Integer, Class<? extends Variable>> registeredSyntaxes = null;
    private static final LogAdapter logger = LogFactory.getLogger(AbstractVariable.class);

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int compareTo(Variable var1);

    @Override
    public abstract int hashCode();

    @Override
    public abstract int getBERLength();

    @Override
    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    @Override
    public abstract void decodeBER(BERInputStream var1) throws IOException;

    @Override
    public abstract void encodeBER(OutputStream var1) throws IOException;

    public static Variable createFromBER(BERInputStream inputStream) throws IOException {
        Variable variable;
        if (!inputStream.markSupported()) {
            throw new IOException("InputStream for decoding a Variable must support marks");
        }
        if (SNMP4JSettings.isExtensibilityEnabled() && registeredSyntaxes == null) {
            AbstractVariable.registerSyntaxes();
        }
        inputStream.mark(2);
        int type = inputStream.read();
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            Class<? extends Variable> c = registeredSyntaxes.get(type);
            if (c == null) {
                throw new IOException("Encountered unsupported variable syntax: " + type);
            }
            try {
                variable = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException aex) {
                throw new IOException("Could not access variable syntax class for: " + c.getName());
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException iex) {
                String errTxt = "Failed to instantiate variable syntax class for: " + c.getName();
                logger.error(errTxt, iex);
                throw new IOException(errTxt, iex);
            }
        } else {
            variable = AbstractVariable.createVariable(type);
        }
        inputStream.reset();
        variable.decodeBER(inputStream);
        return variable;
    }

    private static Variable createVariable(int smiSyntax) {
        switch (smiSyntax) {
            case 6: {
                return new OID();
            }
            case 2: {
                return new Integer32();
            }
            case 4: {
                return new OctetString();
            }
            case 66: {
                return new Gauge32();
            }
            case 65: {
                return new Counter32();
            }
            case 70: {
                return new Counter64();
            }
            case 5: {
                return new Null();
            }
            case 67: {
                return new TimeTicks();
            }
            case 130: {
                return new Null(130);
            }
            case 129: {
                return new Null(129);
            }
            case 128: {
                return new Null(128);
            }
            case 68: {
                return new Opaque();
            }
            case 64: {
                return new IpAddress();
            }
        }
        throw new IllegalArgumentException("Unsupported variable syntax: " + smiSyntax);
    }

    public static Variable createFromSyntax(int smiSyntax) {
        Class<? extends Variable> c;
        if (!SNMP4JSettings.isExtensibilityEnabled()) {
            return AbstractVariable.createVariable(smiSyntax);
        }
        if (registeredSyntaxes == null) {
            AbstractVariable.registerSyntaxes();
        }
        if ((c = registeredSyntaxes.get(smiSyntax)) == null) {
            throw new IllegalArgumentException("Unsupported variable syntax: " + smiSyntax);
        }
        try {
            Variable variable = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return variable;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException iex) {
            String errTxt = "Failed to instantiate variable syntax class for: " + c.getName();
            logger.error(errTxt, iex);
            throw new RuntimeException("Could not instantiate variable syntax class for: " + c.getName());
        }
    }

    private static synchronized void registerSyntaxes() {
        String syntaxes = System.getProperty(SMISYNTAXES_PROPERTIES, SMISYNTAXES_PROPERTIES_DEFAULT);
        InputStream is = Variable.class.getResourceAsStream(syntaxes);
        if (is == null) {
            throw new InternalError("Could not read '" + syntaxes + "' from classpath!");
        }
        Properties props = new Properties();
        try {
            props.load(is);
            Hashtable regSyntaxes = new Hashtable(props.size());
            for (String id : props.stringPropertyNames()) {
                String className = props.getProperty(id);
                try {
                    Class<?> c = Class.forName(className);
                    regSyntaxes.put(Integer.valueOf(id), c);
                }
                catch (ClassCastException | ClassNotFoundException cnfe) {
                    logger.error(cnfe);
                }
            }
            registeredSyntaxes = regSyntaxes;
        }
        catch (IOException iox) {
            String txt = "Could not read '" + syntaxes + "': " + iox.getMessage();
            logger.error((Serializable)((Object)txt));
            throw new InternalError(txt);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                logger.warn(ex);
            }
        }
    }

    @Override
    public abstract int getSyntax();

    @Override
    public boolean isException() {
        return Null.isExceptionSyntax(this.getSyntax());
    }

    @Override
    public abstract String toString();

    @Override
    public abstract int toInt();

    @Override
    public abstract long toLong();

    @Override
    public abstract Object clone();

    public static String getSyntaxString(int syntax) {
        switch (syntax) {
            case 2: {
                return "Integer32";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 67: {
                return "TimeTicks";
            }
            case 65: {
                return "Counter";
            }
            case 70: {
                return "Counter64";
            }
            case 130: {
                return "EndOfMibView";
            }
            case 66: {
                return "Gauge";
            }
            case 64: {
                return "IpAddress";
            }
            case 129: {
                return "NoSuchInstance";
            }
            case 128: {
                return "NoSuchObject";
            }
            case 5: {
                return "Null";
            }
            case 68: {
                return "Opaque";
            }
        }
        return "?";
    }

    @Override
    public final String getSyntaxString() {
        return AbstractVariable.getSyntaxString(this.getSyntax());
    }

    public static int getSyntaxFromString(String syntaxString) {
        for (Object[] aSYNTAX_NAME_MAPPING : SYNTAX_NAME_MAPPING) {
            if (!aSYNTAX_NAME_MAPPING[0].equals(syntaxString)) continue;
            return (Integer)aSYNTAX_NAME_MAPPING[1];
        }
        return 5;
    }

    @Override
    public abstract OID toSubIndex(boolean var1);

    @Override
    public abstract void fromSubIndex(OID var1, boolean var2);

    @Override
    public boolean isDynamic() {
        return false;
    }

    public static boolean equal(AbstractVariable a, AbstractVariable b) {
        return a == null ? b == null : a.equals(b);
    }
}

