/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketConnectionResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketData;
import org.apache.plc4x.java.s7.readwrite.COTPPacketDisconnectRequest;
import org.apache.plc4x.java.s7.readwrite.COTPPacketDisconnectResponse;
import org.apache.plc4x.java.s7.readwrite.COTPPacketTpduError;
import org.apache.plc4x.java.s7.readwrite.COTPParameter;
import org.apache.plc4x.java.s7.readwrite.S7Message;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.PositionAware;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class COTPPacket
implements Message {
    protected final List<COTPParameter> parameters;
    protected final S7Message payload;

    public abstract Short getTpduCode();

    public COTPPacket(List<COTPParameter> parameters, S7Message payload) {
        this.parameters = parameters;
        this.payload = payload;
    }

    public List<COTPParameter> getParameters() {
        return this.parameters;
    }

    public S7Message getPayload() {
        return this.payload;
    }

    protected abstract void serializeCOTPPacketChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("COTPPacket", new WithWriterArgs[0]);
        short headerLength = (short)(this.getLengthInBytes() - ((this.getPayload() != null ? this.getPayload().getLengthInBytes() : 0) + 1));
        FieldWriterFactory.writeImplicitField((String)"headerLength", (Object)headerLength, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"tpduCode", (Object)this.getTpduCode(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeCOTPPacketChild(writeBuffer);
        FieldWriterFactory.writeComplexTypeArrayField((String)"parameters", this.parameters, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("COTPPacket", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        COTPPacket _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        if (this.parameters != null) {
            for (Message message : this.parameters) {
                lengthInBits += message.getLengthInBits();
            }
        }
        if (this.payload != null) {
            lengthInBits += this.payload.getLengthInBits();
        }
        return lengthInBits;
    }

    public static COTPPacket staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer cotpLen;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            cotpLen = (Integer)args[0];
        } else if (args[0] instanceof String) {
            cotpLen = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return COTPPacket.staticParse(readBuffer, cotpLen);
    }

    public static COTPPacket staticParse(ReadBuffer readBuffer, Integer cotpLen) throws ParseException {
        readBuffer.pullContext("COTPPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short headerLength = (Short)FieldReaderFactory.readImplicitField((String)"headerLength", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        short tpduCode = (Short)FieldReaderFactory.readDiscriminatorField((String)"tpduCode", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        COTPPacketBuilder builder = null;
        if (EvaluationHelper.equals((Object)tpduCode, (Object)240)) {
            builder = COTPPacketData.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals((Object)tpduCode, (Object)224)) {
            builder = COTPPacketConnectionRequest.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals((Object)tpduCode, (Object)208)) {
            builder = COTPPacketConnectionResponse.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals((Object)tpduCode, (Object)128)) {
            builder = COTPPacketDisconnectRequest.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals((Object)tpduCode, (Object)192)) {
            builder = COTPPacketDisconnectResponse.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        } else if (EvaluationHelper.equals((Object)tpduCode, (Object)112)) {
            builder = COTPPacketTpduError.staticParseCOTPPacketBuilder(readBuffer, cotpLen);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [tpduCode=" + tpduCode + "]");
        }
        List parameters = FieldReaderFactory.readLengthArrayField((String)"parameters", (DataReader)new DataReaderComplexDefault(() -> COTPPacket.lambda$0(readBuffer, headerLength, (PositionAware)positionAware, startPos), readBuffer), (int)(headerLength + 1 - (positionAware.getPos() - startPos)), (WithReaderArgs[])new WithReaderArgs[0]);
        S7Message payload = (S7Message)FieldReaderFactory.readOptionalField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> S7Message.staticParse(readBuffer), readBuffer), (positionAware.getPos() - startPos < cotpLen ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("COTPPacket", new WithReaderArgs[0]);
        COTPPacket _cOTPPacket = builder.build(parameters, payload);
        return _cOTPPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COTPPacket)) {
            return false;
        }
        COTPPacket that = (COTPPacket)o;
        return this.getParameters() == that.getParameters() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(this.getParameters(), this.getPayload());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    private static /* synthetic */ COTPParameter lambda$0(ReadBuffer readBuffer, short s, PositionAware positionAware, int n) throws ParseException {
        return COTPParameter.staticParse(readBuffer, (short)(s + 1 - (positionAware.getPos() - n)));
    }

    public static interface COTPPacketBuilder {
        public COTPPacket build(List<COTPParameter> var1, S7Message var2);
    }
}

