/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MathUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class DmdbIntervalDT
implements Serializable {
    private static final long serialVersionUID = 3402150044485419841L;
    public static final int LOADPREC_DEFAULT = 2;
    public static final int LOADPREC_MAX = 9;
    public static final int SECDPREC_DEFAULT = 6;
    public static final int SECDPREC_MAX = 6;
    public static final byte QUA_D = 3;
    public static final byte QUA_DH = 4;
    public static final byte QUA_DHM = 5;
    public static final byte QUA_DHMS = 6;
    public static final byte QUA_H = 7;
    public static final byte QUA_HM = 8;
    public static final byte QUA_HMS = 9;
    public static final byte QUA_M = 10;
    public static final byte QUA_MS = 11;
    public static final byte QUA_S = 12;
    public byte type = (byte)3;
    private int leadScale = 2;
    private int secScale = 6;
    private boolean negative = false;
    public int days = 0;
    public int hours = 0;
    public int minutes = 0;
    public int seconds = 0;
    public int fraction = 0;
    private int scaleForSvr = 0;

    private DmdbIntervalDT(byte by, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.type = by;
        this.negative = bl;
        this.leadScale = n7 >> 4 & 0xF;
        this.secScale = n7 & 0xF;
        this.days = n2;
        this.hours = n3;
        this.minutes = n4;
        this.seconds = n5;
        this.fraction = n6;
        this.scaleForSvr = n7;
    }

    public DmdbIntervalDT(byte[] byArray) {
        this.reset(byArray);
    }

    public DmdbIntervalDT(String string) {
        this.parseIntervDTString(string);
    }

    public int hashCode() {
        return this.getDTString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DmdbIntervalDT) {
            DmdbIntervalDT dmdbIntervalDT = (DmdbIntervalDT)object;
            if (dmdbIntervalDT.negative == this.negative && dmdbIntervalDT.type == this.type) {
                switch (this.type) {
                    case 3: {
                        if (this.days != dmdbIntervalDT.days) break;
                        return true;
                    }
                    case 4: {
                        if (this.days != dmdbIntervalDT.days || this.hours != dmdbIntervalDT.hours) break;
                        return true;
                    }
                    case 5: {
                        if (this.days != dmdbIntervalDT.days || this.hours != dmdbIntervalDT.hours || this.minutes != dmdbIntervalDT.minutes) break;
                        return true;
                    }
                    case 6: {
                        if (this.days != dmdbIntervalDT.days || this.hours != dmdbIntervalDT.hours || this.minutes != dmdbIntervalDT.minutes || this.seconds != dmdbIntervalDT.seconds) break;
                        return true;
                    }
                    case 7: {
                        if (this.hours != dmdbIntervalDT.hours) break;
                        return true;
                    }
                    case 8: {
                        if (this.hours != dmdbIntervalDT.hours || this.minutes != dmdbIntervalDT.minutes) break;
                        return true;
                    }
                    case 9: {
                        if (this.hours != dmdbIntervalDT.hours || this.minutes != dmdbIntervalDT.minutes || this.seconds != dmdbIntervalDT.seconds) break;
                        return true;
                    }
                    case 10: {
                        if (this.minutes != dmdbIntervalDT.minutes) break;
                        return true;
                    }
                    case 11: {
                        if (this.minutes != dmdbIntervalDT.minutes || this.seconds != dmdbIntervalDT.seconds) break;
                        return true;
                    }
                    case 12: {
                        if (this.seconds != dmdbIntervalDT.seconds) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getScaleForSvr() {
        return this.scaleForSvr;
    }

    public void reset(byte[] byArray) {
        this.type = byArray[21];
        this.scaleForSvr = ByteUtil.getInt(byArray, 20);
        this.leadScale = this.scaleForSvr >> 4 & 0xF;
        this.secScale = this.scaleForSvr & 0xF;
        switch (this.type) {
            case 3: {
                this.days = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 4: {
                this.days = ByteUtil.getInt(byArray, 0);
                this.hours = ByteUtil.getInt(byArray, 4);
                break;
            }
            case 5: {
                this.days = ByteUtil.getInt(byArray, 0);
                this.hours = ByteUtil.getInt(byArray, 4);
                this.minutes = ByteUtil.getInt(byArray, 8);
                break;
            }
            case 6: {
                this.days = ByteUtil.getInt(byArray, 0);
                this.hours = ByteUtil.getInt(byArray, 4);
                this.minutes = ByteUtil.getInt(byArray, 8);
                this.seconds = ByteUtil.getInt(byArray, 12);
                this.fraction = ByteUtil.getInt(byArray, 16);
                break;
            }
            case 7: {
                this.hours = ByteUtil.getInt(byArray, 4);
                break;
            }
            case 8: {
                this.hours = ByteUtil.getInt(byArray, 4);
                this.minutes = ByteUtil.getInt(byArray, 8);
                break;
            }
            case 9: {
                this.hours = ByteUtil.getInt(byArray, 4);
                this.minutes = ByteUtil.getInt(byArray, 8);
                this.seconds = ByteUtil.getInt(byArray, 12);
                this.fraction = ByteUtil.getInt(byArray, 16);
                break;
            }
            case 10: {
                this.minutes = ByteUtil.getInt(byArray, 8);
                break;
            }
            case 11: {
                this.minutes = ByteUtil.getInt(byArray, 8);
                this.seconds = ByteUtil.getInt(byArray, 12);
                this.fraction = ByteUtil.getInt(byArray, 16);
                break;
            }
            case 12: {
                this.seconds = ByteUtil.getInt(byArray, 12);
                this.fraction = ByteUtil.getInt(byArray, 16);
            }
        }
        if (this.days < 0) {
            this.days = -this.days;
            this.negative = true;
        }
        if (this.hours < 0) {
            this.hours = -this.hours;
            this.negative = true;
        }
        if (this.minutes < 0) {
            this.minutes = -this.minutes;
            this.negative = true;
        }
        if (this.seconds < 0) {
            this.seconds = -this.seconds;
            this.negative = true;
        }
        if (this.fraction < 0) {
            this.fraction = -this.fraction;
            this.negative = true;
        }
    }

    private void setDay(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 1) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)3;
        int n2 = Integer.parseInt(string);
        int n3 = this.days = n2 < 0 ? -n2 : n2;
        if (n2 < 0) {
            this.negative = true;
        }
    }

    private void setHour(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 1) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)7;
        int n2 = Integer.parseInt(string);
        int n3 = this.hours = n2 < 0 ? -n2 : n2;
        if (n2 < 0) {
            this.negative = true;
        }
    }

    private void setMinute(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 1) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)10;
        int n2 = Integer.parseInt(string);
        int n3 = this.minutes = n2 < 0 ? -n2 : n2;
        if (n2 < 0) {
            this.negative = true;
        }
    }

    private void setSecond(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)12;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = 0;
        if (stringArray.length > 1) {
            String string2 = "0." + stringArray[1];
            double d2 = Double.valueOf(string2);
            int n4 = (int)Math.pow(10.0, this.secScale);
            n3 = (int)(d2 * (double)n4);
        }
        this.seconds = n2 < 0 ? -n2 : n2;
        int n5 = this.fraction = n3 < 0 ? -n3 : n3;
        if (n2 < 0 || n3 < 0) {
            this.negative = true;
        }
    }

    private void setHourToSecond(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 4) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)9;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        int n5 = 0;
        if (stringArray.length > 3) {
            String string2 = "0." + stringArray[3];
            double d2 = Double.valueOf(string2);
            int n6 = (int)Math.pow(10.0, this.secScale);
            n5 = (int)(d2 * (double)n6);
        }
        this.hours = n2 < 0 ? -n2 : n2;
        this.minutes = n3 < 0 ? -n3 : n3;
        this.seconds = n4 < 0 ? -n4 : n4;
        int n7 = this.fraction = n5 < 0 ? -n5 : n5;
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            this.negative = true;
        }
    }

    private void setHourToMinute(String string) {
        String[] stringArray = DriverUtil.split(string = string.trim(), " :.");
        if (stringArray.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)8;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        if (stringArray.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.hours = n2 < 0 ? -n2 : n2;
        int n4 = this.minutes = n3 < 0 ? -n3 : n3;
        if (n2 < 0 || n3 < 0) {
            this.negative = true;
        }
    }

    private void setMinuteToSecond(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 3) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)11;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = 0;
        if (stringArray.length > 2) {
            String string2 = "0." + stringArray[2];
            double d2 = Double.valueOf(string2);
            int n5 = (int)Math.pow(10.0, this.secScale);
            n4 = (int)(d2 * (double)n5);
        }
        this.minutes = n2 < 0 ? -n2 : n2;
        this.seconds = n3 < 0 ? -n3 : n3;
        int n6 = this.fraction = n4 < 0 ? -n4 : n4;
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            this.negative = true;
        }
    }

    private void setDayToHour(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)4;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        this.days = n2 < 0 ? -n2 : n2;
        int n4 = this.hours = n3 < 0 ? -n3 : n3;
        if (n2 < 0 || n3 < 0) {
            this.negative = true;
        }
    }

    private void setDayToMinute(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 3) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)5;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        this.days = n2 < 0 ? -n2 : n2;
        this.hours = n3 < 0 ? -n3 : n3;
        int n5 = this.minutes = n4 < 0 ? -n4 : n4;
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            this.negative = true;
        }
    }

    private void setDayToSecond(String string) {
        String[] stringArray = DriverUtil.split(string, " :.");
        if (stringArray.length > 5) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)6;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray[2]);
        int n5 = Integer.parseInt(stringArray[3]);
        int n6 = 0;
        if (stringArray.length > 4) {
            String string2 = "0." + stringArray[4];
            double d2 = Double.valueOf(string2);
            int n7 = (int)Math.pow(10.0, this.secScale);
            n6 = (int)(d2 * (double)n7);
        }
        this.days = n2 < 0 ? -n2 : n2;
        this.hours = n3 < 0 ? -n3 : n3;
        this.minutes = n4 < 0 ? -n4 : n4;
        this.seconds = n5 < 0 ? -n5 : n5;
        int n8 = this.fraction = n6 < 0 ? -n6 : n6;
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0) {
            this.negative = true;
        }
    }

    public final int getDay() {
        return this.days;
    }

    public final int getHour() {
        return this.hours;
    }

    public final int getMinute() {
        return this.minutes;
    }

    public final int getSecond() {
        return this.seconds;
    }

    public final int getMsec() {
        return this.fraction;
    }

    public final byte getDTType() {
        return this.type;
    }

    public final int getSecPrec() {
        return this.secScale;
    }

    public final int getLeadScale() {
        return this.leadScale;
    }

    public final String getDTString() {
        String string = "INTERVAL ";
        switch (this.type) {
            case 3: {
                String string2 = String.valueOf(this.days);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string2.length() < this.leadScale) {
                    int n2 = string2.length();
                    int n3 = this.leadScale;
                    while (n3-- > n2) {
                        string2 = "0" + string2;
                    }
                }
                string = String.valueOf(string) + "'" + string2 + "' DAY(" + this.leadScale + ")";
                break;
            }
            case 4: {
                String string3 = String.valueOf(this.days);
                String string4 = String.valueOf(this.hours);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string3.length() < this.leadScale) {
                    int n4 = string3.length();
                    int n5 = this.leadScale;
                    while (n5-- > n4) {
                        string3 = "0" + string3;
                    }
                }
                if (string4.length() < 2) {
                    string4 = "0" + string4;
                }
                string = String.valueOf(string) + "'" + string3 + " " + string4 + "' DAY(" + this.leadScale + ") TO HOUR";
                break;
            }
            case 5: {
                String string5 = String.valueOf(this.days);
                String string6 = String.valueOf(this.hours);
                String string7 = String.valueOf(this.minutes);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string5.length() < this.leadScale) {
                    int n6 = string5.length();
                    int n7 = this.leadScale;
                    while (n7-- > n6) {
                        string5 = "0" + string5;
                    }
                }
                if (string6.length() < 2) {
                    string6 = "0" + string6;
                }
                if (string7.length() < 2) {
                    string7 = "0" + string7;
                }
                string = String.valueOf(string) + "'" + string5 + " " + string6 + ":" + string7 + "' DAY(" + this.leadScale + ") TO MINUTE";
                break;
            }
            case 6: {
                String string8 = String.valueOf(this.days);
                String string9 = String.valueOf(this.hours);
                String string10 = String.valueOf(this.minutes);
                String string11 = String.valueOf(this.seconds);
                String string12 = this.getMsecString();
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string8.length() < this.leadScale) {
                    int n8 = string8.length();
                    int n9 = this.leadScale;
                    while (n9-- > n8) {
                        string8 = "0" + string8;
                    }
                }
                if (string9.length() < 2) {
                    string9 = "0" + string9;
                }
                if (string10.length() < 2) {
                    string10 = "0" + string10;
                }
                if (string11.length() < 2) {
                    string11 = "0" + string11;
                }
                string = String.valueOf(string) + "'" + string8 + " " + string9 + ":" + string10 + ":" + string11 + (StringUtil.isNotEmpty(string12) ? "." + string12 : "") + "' DAY(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
                break;
            }
            case 7: {
                String string13 = String.valueOf(this.hours);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string13.length() < this.leadScale) {
                    int n10 = string13.length();
                    int n11 = this.leadScale;
                    while (n11-- > n10) {
                        string13 = "0" + string13;
                    }
                }
                string = String.valueOf(string) + "'" + string13 + "' HOUR(" + this.leadScale + ")";
                break;
            }
            case 8: {
                String string14 = String.valueOf(this.hours);
                String string15 = String.valueOf(this.minutes);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string14.length() < this.leadScale) {
                    int n12 = string14.length();
                    int n13 = this.leadScale;
                    while (n13-- > n12) {
                        string14 = "0" + string14;
                    }
                }
                if (string15.length() < 2) {
                    string15 = "0" + string15;
                }
                string = String.valueOf(string) + "'" + string14 + ":" + string15 + "' HOUR(" + this.leadScale + ") TO MINUTE";
                break;
            }
            case 9: {
                String string16 = this.getMsecString();
                String string17 = String.valueOf(this.hours);
                String string18 = String.valueOf(this.minutes);
                String string19 = String.valueOf(this.seconds);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string17.length() < this.leadScale) {
                    int n14 = string17.length();
                    int n15 = this.leadScale;
                    while (n15-- > n14) {
                        string17 = "0" + string17;
                    }
                }
                if (string18.length() < 2) {
                    string18 = "0" + string18;
                }
                if (string19.length() < 2) {
                    string19 = "0" + string19;
                }
                string = String.valueOf(string) + "'" + string17 + ":" + string18 + ":" + string19 + (StringUtil.isNotEmpty(string16) ? "." + string16 : "") + "' HOUR(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
                break;
            }
            case 10: {
                String string20 = String.valueOf(this.minutes);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string20.length() < this.leadScale) {
                    int n16 = string20.length();
                    int n17 = this.leadScale;
                    while (n17-- > n16) {
                        string20 = "0" + string20;
                    }
                }
                string = String.valueOf(string) + "'" + string20 + "' MINUTE(" + this.leadScale + ")";
                break;
            }
            case 11: {
                String string21 = this.getMsecString();
                String string22 = String.valueOf(this.minutes);
                String string23 = String.valueOf(this.seconds);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string22.length() < this.leadScale) {
                    int n18 = string22.length();
                    int n19 = this.leadScale;
                    while (n19-- > n18) {
                        string22 = "0" + string22;
                    }
                }
                if (string23.length() < 2) {
                    string23 = "0" + string23;
                }
                string = String.valueOf(string) + "'" + string22 + ":" + string23 + (StringUtil.isNotEmpty(string21) ? "." + string21 : "") + "' MINUTE(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
                break;
            }
            case 12: {
                String string24 = this.getMsecString();
                String string25 = String.valueOf(this.seconds);
                if (this.negative) {
                    string = String.valueOf(string) + "-";
                }
                if (string25.length() < this.leadScale) {
                    int n20 = string25.length();
                    int n21 = this.leadScale;
                    while (n21-- > n20) {
                        string25 = "0" + string25;
                    }
                }
                string = String.valueOf(string) + "'" + string25 + (StringUtil.isNotEmpty(string24) ? "." + string24 : "") + "' SECOND(" + this.leadScale + ", " + this.secScale + ")";
            }
        }
        return string;
    }

    private String getMsecString() {
        String string = "" + this.fraction;
        int n2 = 6 - string.length();
        while (n2 > 0) {
            string = "0" + string;
            --n2;
        }
        if (string.length() > this.secScale) {
            string = string.substring(0, this.secScale);
        }
        return string;
    }

    public final String toString() {
        return this.getDTString();
    }

    public byte[] encode(int n2) {
        Object object;
        if (n2 == 0) {
            n2 = this.scaleForSvr;
        }
        int n3 = this.days;
        int n4 = this.hours;
        int n5 = this.minutes;
        int n6 = this.seconds;
        int n7 = this.fraction;
        if (n2 != this.scaleForSvr) {
            object = this.convertTo(n2);
            n3 = ((DmdbIntervalDT)object).days;
            n4 = ((DmdbIntervalDT)object).hours;
            n5 = ((DmdbIntervalDT)object).minutes;
            n6 = ((DmdbIntervalDT)object).seconds;
            n7 = ((DmdbIntervalDT)object).fraction;
        } else {
            int n8 = n2 >> 4 & 0xF;
            this.checkScale(n8);
        }
        object = new byte[24];
        ByteUtil.setInt((byte[])object, 0, this.negative ? -n3 : n3);
        ByteUtil.setInt((byte[])object, 4, this.negative ? -n4 : n4);
        ByteUtil.setInt((byte[])object, 8, this.negative ? -n5 : n5);
        ByteUtil.setInt((byte[])object, 12, this.negative ? -n6 : n6);
        ByteUtil.setInt((byte[])object, 16, this.negative ? -n7 : n7);
        ByteUtil.setInt((byte[])object, 20, n2);
        return object;
    }

    public DmdbIntervalDT convertTo(int n2) {
        int n3 = (n2 & 0xFF00) >> 8;
        int n4 = n2 >> 4 & 0xF;
        int n5 = n2 & 0xF;
        int n6 = 0;
        int n7 = 1;
        int n8 = 2;
        int n9 = 3;
        int n10 = 4;
        long[] lArray = new long[5];
        long[] lArray2 = new long[5];
        switch (this.type) {
            case 3: {
                lArray[n6] = this.days;
                break;
            }
            case 4: {
                lArray[n6] = this.days;
                lArray[n7] = this.hours;
                break;
            }
            case 5: {
                lArray[n6] = this.days;
                lArray[n7] = this.hours;
                lArray[n8] = this.minutes;
                break;
            }
            case 6: {
                lArray[n6] = this.days;
                lArray[n7] = this.hours;
                lArray[n8] = this.minutes;
                lArray[n9] = this.seconds;
                lArray[n10] = this.fraction;
                break;
            }
            case 7: {
                lArray[n6] = this.hours / 24;
                lArray[n7] = this.hours % 24;
                break;
            }
            case 8: {
                lArray[n6] = this.hours / 24;
                lArray[n7] = this.hours % 24;
                lArray[n8] = this.minutes;
                break;
            }
            case 9: {
                lArray[n6] = this.hours / 24;
                lArray[n7] = this.hours % 24;
                lArray[n8] = this.minutes;
                lArray[n9] = this.seconds;
                lArray[n10] = this.fraction;
                break;
            }
            case 10: {
                lArray[n6] = this.minutes / 1440;
                lArray[n7] = this.minutes % 1440 / 60;
                lArray[n8] = this.minutes % 1440 % 60;
                break;
            }
            case 11: {
                lArray[n6] = this.minutes / 1440;
                lArray[n7] = this.minutes % 1440 / 60;
                lArray[n8] = this.minutes % 1440 % 60;
                lArray[n9] = this.seconds;
                lArray[n10] = this.fraction;
                break;
            }
            case 12: {
                lArray[n6] = this.seconds / 86400;
                lArray[n7] = this.seconds % 86400 / 3600;
                lArray[n8] = this.seconds % 86400 % 3600 / 60;
                lArray[n9] = this.seconds % 86400 % 3600 % 60;
                lArray[n10] = this.fraction;
                break;
            }
        }
        switch (n3) {
            case 3: {
                lArray2[n6] = lArray[n6];
                if (lArray[n7] >= 12L) {
                    this.incrementDay(3, lArray2);
                }
                if (n4 >= String.valueOf(Math.abs(lArray2[n6])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 4: {
                lArray2[n6] = lArray[n6];
                lArray2[n7] = lArray[n7];
                if (lArray[n8] >= 30L) {
                    this.incrementHour(4, lArray2);
                }
                if (n4 >= String.valueOf(Math.abs(lArray2[n6])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 5: {
                lArray2[n6] = lArray[n6];
                lArray2[n7] = lArray[n7];
                lArray2[n8] = lArray[n8];
                if (lArray[n9] >= 30L) {
                    this.incrementMinute(5, lArray2);
                }
                if (n4 >= String.valueOf(Math.abs(lArray2[n6])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 6: {
                lArray2[n6] = lArray[n6];
                lArray2[n7] = lArray[n7];
                lArray2[n8] = lArray[n8];
                lArray2[n9] = lArray[n9];
                lArray2[n10] = lArray[n10];
                this.convertMSecond(6, lArray2, n5);
                if (n4 >= String.valueOf(Math.abs(lArray2[n6])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 7: {
                lArray2[n7] = lArray[n6] * 24L + lArray[n7];
                if (lArray[n8] >= 30L) {
                    this.incrementHour(7, lArray2);
                }
                if (n4 >= String.valueOf(Math.abs(lArray2[n7])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 8: {
                lArray2[n7] = lArray[n6] * 24L + lArray[n7];
                lArray2[n8] = lArray[n8];
                if (lArray[n9] >= 30L) {
                    this.incrementMinute(8, lArray2);
                }
                if (n4 >= String.valueOf(Math.abs(lArray2[n7])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 9: {
                lArray2[n7] = lArray[n6] * 24L + lArray[n7];
                lArray2[n8] = lArray[n8];
                lArray2[n9] = lArray[n9];
                lArray2[n10] = lArray[n10];
                this.convertMSecond(9, lArray2, n5);
                if (n4 >= String.valueOf(Math.abs(lArray2[n7])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 10: {
                lArray2[n8] = lArray[n6] * 24L * 60L + lArray[n7] * 60L + lArray[n8];
                if (lArray[n9] >= 30L) {
                    this.incrementMinute(10, lArray2);
                }
                if (n4 >= String.valueOf(Math.abs(lArray2[n8])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 11: {
                lArray2[n8] = lArray[n6] * 24L * 60L + lArray[n7] * 60L + lArray[n8];
                lArray2[n9] = lArray[n9];
                lArray2[n10] = lArray[n10];
                this.convertMSecond(11, lArray2, n5);
                if (n4 >= String.valueOf(Math.abs(lArray2[n8])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 12: {
                lArray2[n9] = lArray[n6] * 24L * 60L * 60L + lArray[n7] * 60L * 60L + lArray[n8] * 60L + lArray[n9];
                lArray2[n10] = lArray[n10];
                this.convertMSecond(12, lArray2, n5);
                if (n4 >= String.valueOf(Math.abs(lArray2[n9])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
        }
        return new DmdbIntervalDT((byte)n3, this.negative, (int)lArray2[n6], (int)lArray2[n7], (int)lArray2[n8], (int)lArray2[n9], (int)lArray2[n10], n2);
    }

    private void convertMSecond(int n2, long[] lArray, int n3) {
        int n4 = 4;
        long l2 = lArray[n4];
        if (n3 == 0 || n3 < this.secScale) {
            long l3 = MathUtil.pow(10, 6 - n3 - 1);
            int n5 = (int)(l2 / l3 / 10L);
            if (l2 / l3 % 10L >= 5L) {
                ++n5;
                if ((n5 = (int)((long)n5 * l3 * 10L)) == 1000000) {
                    lArray[n4] = 0L;
                    this.incrementSecond(n2, lArray);
                    return;
                }
            }
            lArray[n4] = n5;
        }
    }

    private void incrementDay(int n2, long[] lArray) {
        int n3;
        int n4 = n3 = 0;
        lArray[n4] = lArray[n4] + 1L;
    }

    private void incrementHour(int n2, long[] lArray) {
        int n3;
        int n4 = n3 = 1;
        lArray[n4] = lArray[n4] + 1L;
        if (lArray[n3] == 24L && n2 < 7) {
            this.incrementDay(n2, lArray);
            lArray[n3] = 0L;
        }
    }

    private void incrementMinute(int n2, long[] lArray) {
        int n3;
        int n4 = n3 = 2;
        lArray[n4] = lArray[n4] + 1L;
        if (lArray[n3] == 60L && n2 < 10) {
            this.incrementHour(n2, lArray);
            lArray[n3] = 0L;
        }
    }

    private void incrementSecond(int n2, long[] lArray) {
        int n3;
        int n4 = n3 = 3;
        lArray[n4] = lArray[n4] + 1L;
        if (lArray[n3] == 60L && n2 < 12) {
            this.incrementMinute(n2, lArray);
            lArray[n3] = 0L;
        }
    }

    public void clear() {
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        this.fraction = 0;
        this.negative = false;
    }

    private int parsePrec(String string) {
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        int n4 = -1;
        if (n3 != -1 && n2 != -1 && n3 > n2 + 1) {
            String string2 = string.substring(n2 + 1, n3).trim();
            n4 = Integer.parseInt(string2);
        }
        return n4;
    }

    private int checkScale(int n2) {
        switch (this.type) {
            case 3: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.days)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.days)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 4: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.days)).length();
                } else if (n2 < String.valueOf(Math.abs(this.days)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.hours) <= 23) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 5: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.days)).length();
                } else if (n2 < String.valueOf(Math.abs(this.days)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.hours) <= 23 && Math.abs(this.minutes) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 6: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.days)).length();
                } else if (n2 < String.valueOf(Math.abs(this.days)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.hours) <= 23 && Math.abs(this.minutes) <= 59 && Math.abs(this.seconds) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 7: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hours)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.hours)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 8: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hours)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hours)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.minutes) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 9: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.hours)).length();
                } else if (n2 < String.valueOf(Math.abs(this.hours)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.minutes) <= 59 && Math.abs(this.seconds) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 10: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.minutes)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.minutes)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 11: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.minutes)).length();
                } else if (n2 < String.valueOf(Math.abs(this.minutes)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.seconds) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 12: {
                if (n2 == -1) {
                    n2 = String.valueOf(Math.abs(this.seconds)).length();
                    break;
                }
                if (n2 >= String.valueOf(Math.abs(this.seconds)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        }
        if (n2 > 9) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        return n2;
    }

    private void setPrecForSvr(String string, String string2, String string3) {
        int n2 = this.checkScale(this.parsePrec(string2));
        this.leadScale = n2 < 2 ? 2 : n2;
        n2 = this.parsePrec(string3);
        this.secScale = n2 > 0 && n2 < 6 ? n2 : 6;
        this.scaleForSvr = (this.type << 8) + (this.leadScale << 4) + this.secScale;
    }

    private String checkSign(String string) {
        if (string.charAt(0) == '-') {
            string = string.substring(1).trim();
            this.negative = true;
        } else if (string.charAt(0) == '+') {
            string = string.substring(1).trim();
            this.negative = false;
        }
        return string;
    }

    private void parseIntervDTString(String string) {
        String string2;
        if (StringUtil.isEmpty(string)) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        if (!(string2 = string.toUpperCase().trim()).startsWith("INTERVAL ")) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        try {
            string2 = string2.substring(string2.indexOf(" ")).trim();
            int n2 = 0;
            String string3 = null;
            if (string2.charAt(0) == '\'' && (n2 = string2.indexOf("'", 1)) != -1) {
                string3 = string2.substring(1, n2).trim();
                string3 = this.checkSign(string3);
                string2 = string2.substring(n2 + 1).trim();
            }
            if (string3 == null) {
                if ((string2 = this.checkSign(string2)).charAt(0) != '\'' || (n2 = string2.indexOf("'", 1)) == -1) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                string3 = string2.substring(1, n2).trim();
                string2 = string2.substring(n2 + 1).trim();
            }
            String string4 = "";
            String string5 = "";
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            n3 = string2.indexOf("DAY");
            if (n3 != -1) {
                n5 = string2.indexOf("TO", n3);
                if (n5 == -1) {
                    string4 = string2.substring(n3).trim();
                    this.setDay(string3);
                } else {
                    string4 = string2.substring(n3, n5).trim();
                    if (string2.indexOf("HOUR", n5) != -1) {
                        this.setDayToHour(string3);
                    } else if (string2.indexOf("MINUTE", n5) != -1) {
                        this.setDayToMinute(string3);
                    } else {
                        n4 = string2.indexOf("SECOND", n5);
                        if (n4 != -1) {
                            string5 = string2.substring(n4);
                            this.setDayToSecond(string3);
                        } else {
                            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                        }
                    }
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
            n3 = string2.indexOf("HOUR");
            if (n3 != -1) {
                n5 = string2.indexOf("TO", n3);
                if (n5 == -1) {
                    string4 = string2.substring(n3);
                    this.setHour(string3);
                } else {
                    string4 = string2.substring(n3, n5);
                    if (string2.indexOf("MINUTE", n5) != -1) {
                        this.setHourToMinute(string3);
                    } else {
                        n4 = string2.indexOf("SECOND", n5);
                        if (n4 != -1) {
                            string5 = string2.substring(n4);
                            this.setHourToSecond(string3);
                        } else {
                            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                        }
                    }
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
            n3 = string2.indexOf("MINUTE");
            if (n3 != -1) {
                n5 = string2.indexOf("TO", n3);
                if (n5 == -1) {
                    string4 = string2.substring(n3);
                    this.setMinute(string3);
                } else {
                    string4 = string2.substring(n3, n5);
                    n4 = string2.indexOf("SECOND", n5);
                    if (n4 != -1) {
                        string5 = string2.substring(n4);
                        this.setMinuteToSecond(string3);
                    } else {
                        DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                    }
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
            n3 = string2.indexOf("SECOND");
            if (n3 != -1) {
                this.setSecond(string3);
                string2 = string2.substring(n3).trim();
                int n6 = string2.indexOf(",");
                if (n6 != -1) {
                    string4 = String.valueOf(string2.substring(0, n6).trim()) + ")";
                    string5 = "(" + string2.substring(n6 + 1).trim();
                }
                this.setPrecForSvr(string2, string4, string5);
                return;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(exception);
        }
        DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
    }

    public static void main(String[] stringArray) {
        DmdbIntervalDT dmdbIntervalDT = new DmdbIntervalDT("interval -'122222' second(2, 4)");
        System.out.println(dmdbIntervalDT.convertTo(550));
    }
}

