/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.util.ByteBufferUtil;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MqttBinaryData {
    public static final int MAX_LENGTH = 65535;
    public static final int EMPTY_LENGTH = 2;

    public static byte @Nullable [] decode(@NotNull ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 2) {
            return null;
        }
        int length = byteBuf.readUnsignedShort();
        if (byteBuf.readableBytes() < length) {
            return null;
        }
        byte[] binary = new byte[length];
        byteBuf.readBytes(binary);
        return binary;
    }

    @Nullable
    public static ByteBuffer decode(@NotNull ByteBuf byteBuf, boolean direct) {
        if (byteBuf.readableBytes() < 2) {
            return null;
        }
        int length = byteBuf.readUnsignedShort();
        if (byteBuf.readableBytes() < length) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBufferUtil.allocate(length, direct);
        byteBuf.readBytes(byteBuffer);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static void encode(byte @NotNull [] binary, @NotNull ByteBuf byteBuf) {
        byteBuf.writeShort(binary.length);
        byteBuf.writeBytes(binary);
    }

    public static void encode(@NotNull ByteBuffer byteBuffer, @NotNull ByteBuf byteBuf) {
        byteBuf.writeShort(byteBuffer.remaining());
        byteBuf.writeBytes(byteBuffer.duplicate());
    }

    public static void encodeEmpty(@NotNull ByteBuf byteBuf) {
        byteBuf.writeShort(0);
    }

    public static boolean isInRange(byte @NotNull [] binary) {
        return binary.length <= 65535;
    }

    public static boolean isInRange(@NotNull ByteBuffer byteBuffer) {
        return byteBuffer.remaining() <= 65535;
    }

    public static int encodedLength(byte @NotNull [] binary) {
        return 2 + binary.length;
    }

    public static int encodedLength(@NotNull ByteBuffer byteBuffer) {
        return 2 + byteBuffer.remaining();
    }

    private MqttBinaryData() {
    }
}

