/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage.scan;

import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.storage.data.ScanStatus;
import com.vesoft.nebula.client.storage.data.VertexRow;
import com.vesoft.nebula.client.storage.data.VertexTableRow;
import com.vesoft.nebula.client.storage.processor.VertexProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanVertexResult
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanVertexResult.class);
    private static final long serialVersionUID = -2446261806893848521L;
    private final List<DataSet> dataSets;
    private final ScanStatus scanStatus;
    private List<VertexTableRow> vertexTableRows = new ArrayList<VertexTableRow>();
    private List<String> propNames = new ArrayList<String>();
    private List<VertexRow> verticeRows = new ArrayList<VertexRow>();
    private Map<ValueWrapper, VertexRow> vidVertices = new HashMap<ValueWrapper, VertexRow>();
    private String decodeType = "utf-8";
    private boolean isEmpty;

    public ScanVertexResult(List<DataSet> dataSets, ScanStatus status) {
        this.dataSets = dataSets;
        this.scanStatus = status;
        this.isEmpty = this.isDatasetEmpty();
    }

    public List<VertexTableRow> getVertexTableRows() {
        if (!this.isEmpty && this.vertexTableRows.isEmpty()) {
            this.constructVertexTableRow();
        }
        return this.vertexTableRows;
    }

    public List<String> getPropNames() {
        if (!this.isEmpty && this.propNames.isEmpty()) {
            this.constructPropNames();
        }
        return this.propNames;
    }

    public VertexRow getVertex(ValueWrapper vid) {
        if (!this.isEmpty && this.vidVertices.isEmpty()) {
            this.constructVertexRow();
        }
        if (this.vidVertices.isEmpty()) {
            return null;
        }
        return this.vidVertices.get(vid);
    }

    public List<VertexRow> getVertices() {
        if (!this.isEmpty && this.verticeRows.isEmpty()) {
            this.constructVertexRow();
        }
        return this.verticeRows;
    }

    public Map<ValueWrapper, VertexRow> getVidVertices() {
        if (!this.isEmpty && this.vidVertices.isEmpty()) {
            this.constructVertexRow();
        }
        return this.vidVertices;
    }

    public boolean isAllSuccess() {
        return this.scanStatus == ScanStatus.ALL_SUCCESS;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private boolean isDatasetEmpty() {
        if (this.dataSets == null || this.dataSets.isEmpty()) {
            return true;
        }
        for (DataSet dataSet : this.dataSets) {
            if (dataSet.getRows().size() <= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructVertexRow() {
        if (this.isEmpty) {
            return;
        }
        ScanVertexResult scanVertexResult = this;
        synchronized (scanVertexResult) {
            if (this.vidVertices.isEmpty()) {
                this.vidVertices = VertexProcessor.constructVertexRow(this.dataSets, this.decodeType);
                this.verticeRows = new ArrayList<VertexRow>(this.vidVertices.values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructVertexTableRow() {
        if (this.isEmpty) {
            return;
        }
        ScanVertexResult scanVertexResult = this;
        synchronized (scanVertexResult) {
            if (this.vertexTableRows.isEmpty()) {
                this.vertexTableRows = VertexProcessor.constructVertexTableRow(this.dataSets, this.decodeType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructPropNames() {
        if (this.isEmpty) {
            return;
        }
        ScanVertexResult scanVertexResult = this;
        synchronized (scanVertexResult) {
            if (this.propNames.isEmpty()) {
                List<byte[]> colNames = this.dataSets.get(0).getColumn_names();
                for (byte[] colName : colNames) {
                    String propName = new String(colName);
                    if (!propName.contains(".")) continue;
                    this.propNames.add(propName.split("\\.")[1]);
                }
            }
        }
    }
}

