/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.ListMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TList;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.ServiceInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListClusterInfoResp
implements TBase,
Serializable,
Cloneable,
Comparable<ListClusterInfoResp> {
    private static final TStruct STRUCT_DESC = new TStruct("ListClusterInfoResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField HOST_SERVICES_FIELD_DESC = new TField("host_services", 13, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Map<String, List<ServiceInfo>> host_services;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int HOST_SERVICES = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ListClusterInfoResp() {
    }

    public ListClusterInfoResp(ErrorCode code, HostAddr leader, Map<String, List<ServiceInfo>> host_services) {
        this();
        this.code = code;
        this.leader = leader;
        this.host_services = host_services;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ListClusterInfoResp(ListClusterInfoResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetHost_services()) {
            this.host_services = TBaseHelper.deepCopy(other.host_services);
        }
    }

    @Override
    public ListClusterInfoResp deepCopy() {
        return new ListClusterInfoResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public ListClusterInfoResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public ListClusterInfoResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<String, List<ServiceInfo>> getHost_services() {
        return this.host_services;
    }

    public ListClusterInfoResp setHost_services(Map<String, List<ServiceInfo>> host_services) {
        this.host_services = host_services;
        return this;
    }

    public void unsetHost_services() {
        this.host_services = null;
    }

    public boolean isSetHost_services() {
        return this.host_services != null;
    }

    public void setHost_servicesIsSet(boolean __value) {
        if (!__value) {
            this.host_services = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetHost_services();
                    break;
                }
                this.setHost_services((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getHost_services();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ListClusterInfoResp)) {
            return false;
        }
        ListClusterInfoResp that = (ListClusterInfoResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetHost_services(), that.isSetHost_services(), this.host_services, that.host_services);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.host_services});
    }

    @Override
    public int compareTo(ListClusterInfoResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetHost_services()).compareTo(other.isSetHost_services());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host_services, other.host_services);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map370 = iprot.readMapBegin();
                        this.host_services = new HashMap<String, List<ServiceInfo>>(Math.max(0, 2 * _map370.size));
                        int _i371 = 0;
                        while (_map370.size < 0 ? iprot.peekMap() : _i371 < _map370.size) {
                            String _key372 = iprot.readString();
                            TList _list374 = iprot.readListBegin();
                            ArrayList<ServiceInfo> _val373 = new ArrayList<ServiceInfo>(Math.max(0, _list374.size));
                            int _i375 = 0;
                            while (_list374.size < 0 ? iprot.peekList() : _i375 < _list374.size) {
                                ServiceInfo _elem376 = new ServiceInfo();
                                _elem376.read(iprot);
                                _val373.add(_elem376);
                                ++_i375;
                            }
                            iprot.readListEnd();
                            this.host_services.put(_key372, _val373);
                            ++_i371;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.host_services != null) {
            oprot.writeFieldBegin(HOST_SERVICES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 15, this.host_services.size()));
            for (Map.Entry<String, List<ServiceInfo>> _iter377 : this.host_services.entrySet()) {
                oprot.writeString(_iter377.getKey());
                oprot.writeListBegin(new TList(12, _iter377.getValue().size()));
                for (ServiceInfo _iter378 : _iter377.getValue()) {
                    _iter378.write(oprot);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ListClusterInfoResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("host_services");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost_services() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost_services(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("host_services", 3, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new StructMetaData(12, ServiceInfo.class)))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ListClusterInfoResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<String, List<ServiceInfo>> host_services;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setHost_services(Map<String, List<ServiceInfo>> host_services) {
            this.host_services = host_services;
            return this;
        }

        public ListClusterInfoResp build() {
            ListClusterInfoResp result = new ListClusterInfoResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setHost_services(this.host_services);
            return result;
        }
    }
}

