/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusPDUWriteMultipleCoilsRequest
extends ModbusPDU
implements Message {
    protected final int startingAddress;
    protected final int quantity;
    protected final byte[] value;

    @Override
    public Boolean getErrorFlag() {
        return false;
    }

    @Override
    public Byte getFunctionFlag() {
        return (byte)15;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public ModbusPDUWriteMultipleCoilsRequest(int startingAddress, int quantity, byte[] value) {
        this.startingAddress = startingAddress;
        this.quantity = quantity;
        this.value = value;
    }

    public int getStartingAddress() {
        return this.startingAddress;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusPDUWriteMultipleCoilsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"startingAddress", (Object)this.startingAddress, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"quantity", (Object)this.quantity, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        short byteCount = (short)StaticHelper.COUNT((Object)this.getValue());
        FieldWriterFactory.writeImplicitField((String)"byteCount", (Object)byteCount, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"value", (byte[])this.value, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUWriteMultipleCoilsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusPDUWriteMultipleCoilsRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        if (this.value != null) {
            lengthInBits += 8 * this.value.length;
        }
        return lengthInBits;
    }

    public static ModbusPDU.ModbusPDUBuilder staticParseModbusPDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusPDUWriteMultipleCoilsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int startingAddress = (Integer)FieldReaderFactory.readSimpleField((String)"startingAddress", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int quantity = (Integer)FieldReaderFactory.readSimpleField((String)"quantity", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        short byteCount = (Short)FieldReaderFactory.readImplicitField((String)"byteCount", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] value = readBuffer.readByteArray("value", Math.toIntExact(byteCount), new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUWriteMultipleCoilsRequest", new WithReaderArgs[0]);
        return new ModbusPDUWriteMultipleCoilsRequestBuilderImpl(startingAddress, quantity, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUWriteMultipleCoilsRequest)) {
            return false;
        }
        ModbusPDUWriteMultipleCoilsRequest that = (ModbusPDUWriteMultipleCoilsRequest)o;
        return this.getStartingAddress() == that.getStartingAddress() && this.getQuantity() == that.getQuantity() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStartingAddress(), this.getQuantity(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusPDUWriteMultipleCoilsRequestBuilderImpl
    implements ModbusPDU.ModbusPDUBuilder {
        private final int startingAddress;
        private final int quantity;
        private final byte[] value;

        public ModbusPDUWriteMultipleCoilsRequestBuilderImpl(int startingAddress, int quantity, byte[] value) {
            this.startingAddress = startingAddress;
            this.quantity = quantity;
            this.value = value;
        }

        @Override
        public ModbusPDUWriteMultipleCoilsRequest build() {
            ModbusPDUWriteMultipleCoilsRequest modbusPDUWriteMultipleCoilsRequest = new ModbusPDUWriteMultipleCoilsRequest(this.startingAddress, this.quantity, this.value);
            return modbusPDUWriteMultipleCoilsRequest;
        }
    }
}

