/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.BitIoConstraints;
import com.github.jinahya.bit.io.BitOutput;
import com.github.jinahya.bit.io.BitWritable;
import java.io.IOException;
import java.nio.charset.Charset;

public class ExtendedBitOutput {
    public static <T extends BitWritable> void writeObject(BitOutput output, T value) throws IOException {
        if (output == null) {
            throw new NullPointerException("output is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        value.write(output);
    }

    public static int writeBytes(BitOutput bitOutput, int lengthSize, boolean byteUnsigned, int byteSize, byte[] value) throws IOException {
        if (bitOutput == null) {
            throw new NullPointerException("bitOutput is null");
        }
        BitIoConstraints.requireValidSizeInt(true, lengthSize);
        BitIoConstraints.requireValidSizeByte(byteUnsigned, byteSize);
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        int length = value.length & (1 << lengthSize) - 1;
        bitOutput.writeInt(true, lengthSize, length);
        for (int i = 0; i < length; ++i) {
            bitOutput.writeByte(byteUnsigned, byteSize, value[i]);
        }
        return length;
    }

    public static int writeBytes(BitOutput bitOutput, int lengthSize, int byteSize, byte[] value) throws IOException {
        return ExtendedBitOutput.writeBytes(bitOutput, lengthSize, false, byteSize, value);
    }

    public static int writeShorts(BitOutput bitOutput, int lengthSize, int shortSize, short[] value) throws IOException {
        if (bitOutput == null) {
            throw new NullPointerException("bitOutput is null");
        }
        BitIoConstraints.requireValidSizeInt(true, lengthSize);
        BitIoConstraints.requireValidSizeShort(false, shortSize);
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        int length = value.length & (1 << lengthSize) - 1;
        bitOutput.writeInt(true, lengthSize, length);
        for (int i = 0; i < length; ++i) {
            bitOutput.writeShort(false, shortSize, value[i]);
        }
        return length;
    }

    public static int writeInts(BitOutput bitOutput, int lengthSize, int intSize, int[] value) throws IOException {
        if (bitOutput == null) {
            throw new NullPointerException("bitOutput is null");
        }
        BitIoConstraints.requireValidSizeInt(true, lengthSize);
        BitIoConstraints.requireValidSizeInt(false, intSize);
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        int length = value.length & (1 << lengthSize) - 1;
        bitOutput.writeInt(true, lengthSize, length);
        for (int i = 0; i < length; ++i) {
            bitOutput.writeInt(false, intSize, value[i]);
        }
        return length;
    }

    public static int writeLongs(BitOutput bitOutput, int lengthSize, int longSize, long[] value) throws IOException {
        if (bitOutput == null) {
            throw new NullPointerException("bitOutput is null");
        }
        BitIoConstraints.requireValidSizeInt(true, lengthSize);
        BitIoConstraints.requireValidSizeLong(false, longSize);
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        int length = value.length & (1 << lengthSize) - 1;
        bitOutput.writeInt(true, lengthSize, length);
        for (int i = 0; i < length; ++i) {
            bitOutput.writeLong(false, longSize, value[i]);
        }
        return length;
    }

    public static int writeString(BitOutput bitOutput, int lengthSize, String value, String charsetName) throws IOException {
        return ExtendedBitOutput.writeBytes(bitOutput, lengthSize, 8, value.getBytes(charsetName));
    }

    public static int writeString(BitOutput bitOutput, int lengthSize, String value, Charset charset) throws IOException {
        return ExtendedBitOutput.writeBytes(bitOutput, lengthSize, 8, value.getBytes(charset));
    }

    public static int writeAscii(BitOutput bitOutput, int lengthSize, String value) throws IOException {
        return ExtendedBitOutput.writeBytes(bitOutput, lengthSize, true, 7, value.getBytes("ASCII"));
    }

    protected ExtendedBitOutput() {
    }
}

