/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.client.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiSession;
import org.apache.hertzbeat.collector.collect.ipmi2.client.UdpConnection;
import org.apache.hertzbeat.collector.collect.ipmi2.client.handler.IpmiHandler;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.chassis.GetChassisStatusRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.chassis.GetChassisStatusResponse;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;

public class ChassisHandler
implements IpmiHandler {
    Map<String, String> parseValue = new HashMap<String, String>();

    @Override
    public void handler(IpmiSession session, UdpConnection connection, CollectRep.MetricsData.Builder builder, Metrics metrics) throws IOException {
        GetChassisStatusResponse getChassisStatusResponse = connection.get(session, new GetChassisStatusRequest(), GetChassisStatusResponse.class);
        this.parseFieldToMap(getChassisStatusResponse);
        CollectRep.ValueRow.Builder valueRowBuilder = CollectRep.ValueRow.newBuilder();
        for (Metrics.Field field : metrics.getFields()) {
            if (!this.parseValue.containsKey(field.getField())) {
                valueRowBuilder.addColumn("&nbsp;");
                continue;
            }
            valueRowBuilder.addColumn(this.parseValue.get(field.getField()));
        }
        builder.addValueRow(valueRowBuilder.build());
    }

    public void parseFieldToMap(GetChassisStatusResponse getChassisStatusResponse) {
        this.parseValue.put("system_power", getChassisStatusResponse.isPowerOn ? "on" : "off");
        this.parseValue.put("power_overload", getChassisStatusResponse.isPowerOverload ? "true" : "false");
        this.parseValue.put("power_interlock", getChassisStatusResponse.isPowerInterlock ? "true" : "false");
        this.parseValue.put("power_fault", getChassisStatusResponse.isPowerFault ? "true" : "false");
        this.parseValue.put("power_control_fault", getChassisStatusResponse.isPowerControlFault ? "true" : "false");
        this.parseValue.put("power_restore_policy", getChassisStatusResponse.powerRestorePolicy);
        this.parseValue.put("last_power_event", getChassisStatusResponse.lastPowerEvent);
        this.parseValue.put("fan_fault", getChassisStatusResponse.isFanFault ? "true" : "false");
        this.parseValue.put("drive_fault", getChassisStatusResponse.isDriveFault ? "true" : "false");
        this.parseValue.put("front_panel_lockout_active", getChassisStatusResponse.isFrontPanelLockoutActive ? "true" : "false");
    }
}

