/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiCompletionCode implements IpmiCode.Code
{
    CompletedNormally(0, "Command Completed Normally."),
    NodeBusy(192, "Node Busy. Command could not be processed because command processing resources are temporarily unavailable."),
    InvalidCommand(193, "Invalid Command. Used to indicate an unrecognized or unsupported command."),
    InvalidForGivenLUN(194, "Command invalid for given LUN."),
    Timeout(195, "Timeout while processing command. Response unavailable."),
    OutOfSpace(196, "Out of space. Command could not be completed because of a lack of storage space required to execute the given command operation."),
    ReservationCanceled(197, "Reservation Canceled or Invalid Reservation ID."),
    RequestDataTruncated(198, "Request data truncated."),
    RequestDataLengthInvalid(199, "Request data length invalid."),
    RequestDataFieldLengthExceed(200, "Request data field length limit exceeded."),
    ParameterOutOfRange(201, "Parameter out of range. "),
    CannotReturnRequestedData(202, "Cannot return number of requested data bytes."),
    RequestDataNotPresent(203, "Requested Sensor, data, or record not present"),
    InvalidDataFieldRequest(204, "Invalid data field in Request"),
    CommandIllegalForSDR(205, "Command illegal for specified sensor or record type."),
    CommandResponseNotProvided(206, "Command response could not be provided."),
    DuplicateRequest(207, "Cannot execute duplicated request. "),
    SDRRepositoryInUpdateMode(208, "Command response could not be provided. SDR Repository in update mode"),
    FirmwareUpdateMode(209, "Command response could not be provided. Device in firmware update mode."),
    BMCInitialization(210, "Command response could not be provided. BMC initialization or initialization agent in progress."),
    DestinationUnavailable(211, "Destination unavailable. Cannot deliver request to selected destination."),
    InsufficientPrivilege(212, "Cannot execute command due to insufficient privilege level or other security-based restriction (e.g. disabled for 'firmware firewall)"),
    NotSupportedCommand(213, "Cannot execute command. Command, or request parameter(s), not supported in present state."),
    ParameterIllegal(214, "Cannot execute command. Parameter is illegal because command sub-function has been disabled or is unavailable (e.g. disabled for 'firmware firewall')."),
    UnspecifiedError(255, "Unspecified error.");

    private final byte code;
    private final String description;
    public static final int MASK = 255;

    private IpmiCompletionCode(int code, String description) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.description = description;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

