/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulDatabaseMetaData;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSStatement;
import com.taosdata.jdbc.ws.entity.RequestFactory;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class WSConnection
extends AbstractConnection {
    private final Transport transport;
    private final DatabaseMetaData metaData;
    private final String database;
    private final RequestFactory factory;

    public WSConnection(String url, Properties properties, Transport transport, String database) {
        super(properties);
        this.transport = transport;
        this.database = database;
        this.metaData = new RestfulDatabaseMetaData(url, properties.getProperty("user"), this);
        this.factory = new RequestFactory();
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new WSStatement(this.transport, this.database, this, this.factory);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void close() throws SQLException {
        this.transport.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.transport.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.metaData;
    }
}

