/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.vertex;

import java.util.Objects;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.edge.Edges;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;

public class DefaultVertex
implements Vertex {
    private String label;
    private Id id;
    private Value value;
    private Edges edges;
    private Properties properties;
    private boolean active;

    public DefaultVertex(GraphFactory graphFactory) {
        this(graphFactory, null, null);
    }

    public DefaultVertex(GraphFactory graphFactory, Id id, Value value) {
        this(graphFactory, "", id, value);
    }

    public DefaultVertex(GraphFactory graphFactory, String label, Id id, Value value) {
        this.label = label;
        this.id = id;
        this.value = value;
        this.edges = graphFactory.createEdges();
        this.properties = graphFactory.createProperties();
        this.active = true;
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public Id id() {
        return this.id;
    }

    public void id(Id id) {
        this.id = id;
    }

    public <V extends Value> V value() {
        return (V)this.value;
    }

    public <V extends Value> void value(V value) {
        this.value = value;
    }

    public int numEdges() {
        return this.edges.size();
    }

    public Edges edges() {
        return this.edges;
    }

    public void edges(Edges edges) {
        this.edges = edges;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public Properties properties() {
        return this.properties;
    }

    public void properties(Properties properties) {
        this.properties = properties;
    }

    public <T extends Value> T property(String key) {
        return (T)this.properties.get(key);
    }

    public boolean active() {
        return this.active;
    }

    public void inactivate() {
        this.active = false;
    }

    public void reactivate() {
        this.active = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultVertex)) {
            return false;
        }
        DefaultVertex other = (DefaultVertex)obj;
        return this.active == other.active && Objects.equals(this.id, other.id) && Objects.equals(this.value, other.value) && Objects.equals(this.edges, other.edges) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value, this.edges, this.properties, this.active);
    }

    public String toString() {
        return String.format("DefaultVertex{id=%s, value=%s, edges.size=%s, active=%s}", this.id, this.value, this.edges.size(), this.active);
    }
}

