/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.receiver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.UnsafeBytesInput;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.concurrent.BarrierEvent;

public class MessageRecvBuffers {
    private final long bytesLimit;
    private long totalBytes = 0L;
    private final List<byte[]> buffers;
    private final BarrierEvent sortFinished = new BarrierEvent();
    private final long waitSortedTimeout;

    public MessageRecvBuffers(long bytesLimit, long waitSortedTimeout) {
        this.bytesLimit = bytesLimit;
        this.waitSortedTimeout = waitSortedTimeout;
        this.buffers = new ArrayList<byte[]>();
    }

    public void addBuffer(NetworkBuffer data) {
        byte[] bytes = data.copyToByteArray();
        this.buffers.add(bytes);
        this.totalBytes += (long)bytes.length;
    }

    public boolean full() {
        return this.totalBytes >= this.bytesLimit;
    }

    public List<RandomAccessInput> buffers() {
        ArrayList<RandomAccessInput> inputs = new ArrayList<RandomAccessInput>(this.buffers.size());
        for (byte[] buffer : this.buffers) {
            inputs.add((RandomAccessInput)new UnsafeBytesInput(buffer));
        }
        return inputs;
    }

    public void prepareSort() {
        this.buffers.clear();
        this.totalBytes = 0L;
        this.sortFinished.reset();
    }

    public void waitSorted() {
        if (this.buffers.isEmpty()) {
            return;
        }
        try {
            boolean sorted = this.sortFinished.await(this.waitSortedTimeout);
            if (!sorted) {
                throw new ComputerException("Buffers have not been sorted in %s ms", new Object[]{this.waitSortedTimeout});
            }
        }
        catch (InterruptedException e) {
            throw new ComputerException("Interrupted while waiting buffers to be sorted", (Throwable)e);
        }
    }

    public void signalSorted() {
        this.sortFinished.signalAll();
    }

    public long totalBytes() {
        return this.totalBytes;
    }
}

