/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.buffer;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public class SubKvEntriesInput
implements EntryIterator {
    private final RandomAccessInput input;
    private final RandomAccessInput useAccessInput;
    private int size;
    private final boolean useInlinePointer;

    public SubKvEntriesInput(KvEntry kvEntry, boolean useInlinePointer) {
        try {
            this.input = IOFactory.createBytesInput(kvEntry.value().bytes());
            this.useAccessInput = this.input.duplicate();
            this.size = this.input.readFixedInt();
            this.useInlinePointer = useInlinePointer;
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    public SubKvEntriesInput(KvEntry kvEntry) {
        this(kvEntry, true);
    }

    public boolean hasNext() {
        return this.size > 0;
    }

    public KvEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.size;
        return EntriesUtil.subKvEntryFromInput(this.input, this.useAccessInput, this.useInlinePointer);
    }

    public void close() throws Exception {
        this.input.close();
        this.useAccessInput.close();
    }
}

