/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.tls;

import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.tls.TlsSystemConfig;
import com.alibaba.nacos.common.utils.ClassUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.MD5Utils2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TlsFileWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsFileWatcher.class);
    private AtomicBoolean started = new AtomicBoolean(false);
    private final int checkInterval = TlsSystemConfig.tlsFileCheckInterval;
    private Map<String, String> fileMd5Map = new HashMap<String, String>();
    private ConcurrentHashMap<String, FileChangeListener> watchFilesMap = new ConcurrentHashMap();
    private final ScheduledExecutorService service = ExecutorFactory.Managed.newSingleScheduledExecutorService(ClassUtils.getCanonicalName(TlsFileWatcher.class), new NameThreadFactory("com.alibaba.nacos.core.common.tls"));
    private static TlsFileWatcher tlsFileWatcher = new TlsFileWatcher();

    private TlsFileWatcher() {
        this.start();
    }

    public static TlsFileWatcher getInstance() {
        return tlsFileWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(FileChangeListener fileChangeListener, String ... filePaths) throws IOException {
        for (String filePath : filePaths) {
            if (filePath == null || !new File(filePath).exists()) continue;
            this.watchFilesMap.put(filePath, fileChangeListener);
            FileInputStream in = null;
            try {
                in = new FileInputStream(filePath);
                this.fileMd5Map.put(filePath, MD5Utils2.md5Hex(IoUtils.toString(in, "UTF-8"), "UTF-8"));
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
            IoUtils.closeQuietly(in);
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.service.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (Map.Entry item : TlsFileWatcher.this.watchFilesMap.entrySet()) {
                        String newHash;
                        String filePath = (String)item.getKey();
                        FileInputStream in = null;
                        try {
                            in = new FileInputStream(filePath);
                            newHash = MD5Utils2.md5Hex(IoUtils.toString(in, "UTF-8"), "UTF-8");
                        }
                        catch (Exception ignored) {
                            try {
                                LOGGER.warn(" service has exception when calculate the file MD5. " + ignored);
                            }
                            catch (Throwable throwable) {
                                IoUtils.closeQuietly(in);
                                throw throwable;
                            }
                            IoUtils.closeQuietly(in);
                            continue;
                        }
                        IoUtils.closeQuietly(in);
                        if (newHash.equals(TlsFileWatcher.this.fileMd5Map.get(filePath))) continue;
                        LOGGER.info(filePath + " file hash changed,need reload sslcontext");
                        TlsFileWatcher.this.fileMd5Map.put(filePath, newHash);
                        ((FileChangeListener)item.getValue()).onChanged(filePath);
                        LOGGER.info(filePath + " onChanged success!");
                    }
                }
            }, 1L, this.checkInterval, TimeUnit.MINUTES);
        }
    }

    public static interface FileChangeListener {
        public void onChanged(String var1);
    }
}

