/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap.builders;

import java.util.Map;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.bootstrap.builders.AbstractBuilder;

public class MetadataReportBuilder
extends AbstractBuilder<MetadataReportConfig, MetadataReportBuilder> {
    private String address;
    private String username;
    private String password;
    private Integer timeout;
    private String group;
    private Map<String, String> parameters;
    private Integer retryTimes;
    private Integer retryPeriod;
    private Boolean cycleReport;
    private Boolean syncReport;

    public static MetadataReportBuilder newBuilder() {
        return new MetadataReportBuilder();
    }

    public MetadataReportBuilder address(String address) {
        this.address = address;
        return this.getThis();
    }

    public MetadataReportBuilder username(String username) {
        this.username = username;
        return this.getThis();
    }

    public MetadataReportBuilder password(String password) {
        this.password = password;
        return this.getThis();
    }

    public MetadataReportBuilder timeout(Integer timeout) {
        this.timeout = timeout;
        return this.getThis();
    }

    public MetadataReportBuilder group(String group) {
        this.group = group;
        return this.getThis();
    }

    public MetadataReportBuilder appendParameters(Map<String, String> appendParameters) {
        this.parameters = MetadataReportBuilder.appendParameters(this.parameters, appendParameters);
        return this.getThis();
    }

    public MetadataReportBuilder appendParameter(String key, String value) {
        this.parameters = MetadataReportBuilder.appendParameter(this.parameters, key, value);
        return this.getThis();
    }

    public MetadataReportBuilder retryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
        return this.getThis();
    }

    public MetadataReportBuilder retryPeriod(Integer retryPeriod) {
        this.retryPeriod = retryPeriod;
        return this.getThis();
    }

    public MetadataReportBuilder cycleReport(Boolean cycleReport) {
        this.cycleReport = cycleReport;
        return this.getThis();
    }

    public MetadataReportBuilder syncReport(Boolean syncReport) {
        this.syncReport = syncReport;
        return this.getThis();
    }

    @Override
    public MetadataReportConfig build() {
        MetadataReportConfig metadataReport = new MetadataReportConfig();
        super.build(metadataReport);
        metadataReport.setAddress(this.address);
        metadataReport.setUsername(this.username);
        metadataReport.setPassword(this.password);
        metadataReport.setTimeout(this.timeout);
        metadataReport.setGroup(this.group);
        metadataReport.setParameters(this.parameters);
        metadataReport.setRetryTimes(this.retryTimes);
        metadataReport.setRetryPeriod(this.retryPeriod);
        metadataReport.setCycleReport(this.cycleReport);
        metadataReport.setSyncReport(this.syncReport);
        return metadataReport;
    }

    @Override
    protected MetadataReportBuilder getThis() {
        return this;
    }
}

