/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import org.apache.ozhera.app.api.message.HeraAppInfoModifyMessage;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rocketMqHeraAppProducer")
public class RocketMqHeraAppProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMqHeraAppProducer.class);
    @NacosValue(value="${hera.app.modify.notice.topic}")
    private String topic;
    @NacosValue(value="${hera.app.modify.notice.tag}")
    private String tag;
    @Autowired
    private DefaultMQProducer producer;

    public void pushHeraAppMsg(HeraAppInfoModifyMessage heraAppMessage) {
        log.info("pushHeraAppMsg send rocketmq message : {}", (Object)heraAppMessage.toString());
        Message msg = new Message(this.topic, this.tag, JSON.toJSONString((Object)heraAppMessage).getBytes());
        try {
            this.producer.send(msg);
            log.info("pushHeraAppMsg send rocketmq message success! msg : {}", (Object)heraAppMessage.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("pushHeraAppMsg error: " + e.getMessage(), (Throwable)e);
        }
    }
}

