/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.Enablement;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.MicroProfileMetricsRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@Singleton
public class MicroProfileMetricsProvider
implements MetricsProvider {
    static final String DISABLED = "smallrye.faulttolerance.mpmetrics.disabled";
    private final boolean enabled;
    private final MetricRegistry registry;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @Inject
    MicroProfileMetricsProvider(@RegistryType(type=MetricRegistry.Type.BASE) Provider<MetricRegistry> registry, Enablement enablement, @ConfigProperty(name="smallrye.faulttolerance.mpmetrics.disabled", defaultValue="false") boolean mpMetricsDisabled, ExecutorHolder executorHolder) {
        this.enabled = enablement.metrics() && !mpMetricsDisabled;
        this.registry = (MetricRegistry)registry.get();
        if (this.enabled) {
            Metadata metadata = Metadata.builder().withName("ft.timer.scheduled").withUnit("none").build();
            Timer timer = executorHolder.getTimer();
            this.registry.gauge(metadata, (Object)timer, Timer::countScheduledTasks, new Tag[]{new Tag("id", "" + timer.getId())});
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.enabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new MicroProfileMetricsRecorder(this.registry, operation));
        }
        return MetricsRecorder.NOOP;
    }
}

