/*
 * Decompiled with CFR 0.152.
 */
package coursier.shaded.org.jsoup.nodes;

import coursier.shaded.org.jsoup.SerializationException;
import coursier.shaded.org.jsoup.helper.Validate;
import coursier.shaded.org.jsoup.nodes.Document;
import coursier.shaded.org.jsoup.nodes.Entities;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Map.Entry<String, String>,
Cloneable {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    private String value;

    public Attribute(String key, String value2) {
        Validate.notNull(key);
        Validate.notNull(value2);
        this.key = key.trim();
        Validate.notEmpty(key);
        this.value = value2;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        Validate.notEmpty(key);
        this.key = key.trim();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value2) {
        Validate.notNull(value2);
        String old = this.value;
        this.value = value2;
        return old;
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        try {
            this.html(accum, new Document("").outputSettings());
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
        return accum.toString();
    }

    protected void html(Appendable accum, Document.OutputSettings out2) throws IOException {
        accum.append(this.key);
        if (!this.shouldCollapseAttribute(out2)) {
            accum.append("=\"");
            Entities.escape(accum, this.value, out2, true, false, false);
            accum.append('\"');
        }
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value2 = Entities.unescape(encodedValue, true);
        return new Attribute(unencodedKey, value2);
    }

    protected boolean isDataAttribute() {
        return this.key.startsWith("data-") && this.key.length() > "data-".length();
    }

    protected final boolean shouldCollapseAttribute(Document.OutputSettings out2) {
        return ("".equals(this.value) || this.value.equalsIgnoreCase(this.key)) && out2.syntax() == Document.OutputSettings.Syntax.html && this.isBooleanAttribute();
    }

    protected boolean isBooleanAttribute() {
        return Arrays.binarySearch(booleanAttributes, this.key) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return !(this.value == null ? attribute.value != null : !this.value.equals(attribute.value));
    }

    @Override
    public int hashCode() {
        int result2 = this.key != null ? this.key.hashCode() : 0;
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        return result2;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

