/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control.clientsession;

import java.io.IOException;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.service.rpc.thrift.TSConnectionType;

public class ClientSession
extends IClientSession {
    private final Socket clientSocket;
    private final Set<Long> statements = new CopyOnWriteArraySet<Long>();

    public ClientSession(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    @Override
    public String getClientAddress() {
        return this.clientSocket.getInetAddress().getHostAddress();
    }

    @Override
    public int getClientPort() {
        return this.clientSocket.getPort();
    }

    @Override
    TSConnectionType getConnectionType() {
        return TSConnectionType.THRIFT_BASED;
    }

    @Override
    String getConnectionId() {
        return String.format("%s:%s", this.getClientAddress(), this.getClientPort());
    }

    @Override
    public Set<Long> getStatementIds() {
        return this.statements;
    }

    public void shutdownStream() {
        if (!this.clientSocket.isInputShutdown()) {
            try {
                this.clientSocket.shutdownInput();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.clientSocket.isOutputShutdown()) {
            try {
                this.clientSocket.shutdownOutput();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

