/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ArithmeticNegationTransformer
extends Transformer {
    private final LayerPointReader layerPointReader;

    public ArithmeticNegationTransformer(LayerPointReader layerPointReader) {
        this.layerPointReader = layerPointReader;
    }

    @Override
    public boolean isConstantPointReader() {
        return this.layerPointReader.isConstantPointReader();
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.layerPointReader.next()) {
            return false;
        }
        if (!this.isConstantPointReader()) {
            this.cachedTime = this.layerPointReader.currentTime();
        }
        if (this.layerPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            switch (this.layerPointReader.getDataType()) {
                case INT32: {
                    this.cachedInt = -this.layerPointReader.currentInt();
                    break;
                }
                case INT64: {
                    this.cachedLong = -this.layerPointReader.currentLong();
                    break;
                }
                case FLOAT: {
                    this.cachedFloat = -this.layerPointReader.currentFloat();
                    break;
                }
                case DOUBLE: {
                    this.cachedDouble = -this.layerPointReader.currentDouble();
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type: " + this.layerPointReader.getDataType().toString());
                }
            }
        }
        this.layerPointReader.readyForNext();
        return true;
    }

    @Override
    public TSDataType getDataType() {
        return this.layerPointReader.getDataType();
    }
}

