/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.subscription.config.TopicConfig;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeSubscribeResp
extends TPipeSubscribeResp {
    private transient Map<String, TopicConfig> topics = new HashMap<String, TopicConfig>();

    public Map<String, TopicConfig> getTopics() {
        return this.topics;
    }

    public static PipeSubscribeSubscribeResp toTPipeSubscribeResp(TSStatus status) {
        PipeSubscribeSubscribeResp resp = new PipeSubscribeSubscribeResp();
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.ACK.getType();
        return resp;
    }

    public static PipeSubscribeSubscribeResp toTPipeSubscribeResp(TSStatus status, Map<String, TopicConfig> topics) throws IOException {
        PipeSubscribeSubscribeResp resp = PipeSubscribeSubscribeResp.toTPipeSubscribeResp(status);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)topics.size(), (OutputStream)outputStream);
            for (Map.Entry<String, TopicConfig> entry : topics.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                entry.getValue().serialize(outputStream);
            }
            resp.body = Collections.singletonList(ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
        }
        return resp;
    }

    public static PipeSubscribeSubscribeResp fromTPipeSubscribeResp(TPipeSubscribeResp subscribeResp) {
        PipeSubscribeSubscribeResp resp = new PipeSubscribeSubscribeResp();
        if (Objects.nonNull(subscribeResp.body)) {
            for (ByteBuffer byteBuffer : subscribeResp.body) {
                if (!Objects.nonNull(byteBuffer) || !byteBuffer.hasRemaining()) continue;
                int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
                HashMap<String, TopicConfig> topics = new HashMap<String, TopicConfig>();
                for (int i = 0; i < size; ++i) {
                    String topicName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
                    TopicConfig topicConfig = TopicConfig.deserialize(byteBuffer);
                    topics.put(topicName, topicConfig);
                }
                resp.topics = topics;
                break;
            }
        }
        resp.status = subscribeResp.status;
        resp.version = subscribeResp.version;
        resp.type = subscribeResp.type;
        resp.body = subscribeResp.body;
        return resp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeSubscribeResp that = (PipeSubscribeSubscribeResp)((Object)obj);
        return Objects.equals(this.topics, that.topics) && Objects.equals(this.status, that.status) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.topics, this.status, this.version, this.type, this.body);
    }
}

