/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TemplateFilter
extends SchemaFilter {
    private final String templateName;
    private final boolean isEqual;

    public TemplateFilter(String templateName, boolean isEqual) {
        this.templateName = templateName;
        this.isEqual = isEqual;
    }

    public TemplateFilter(ByteBuffer byteBuffer) {
        this.templateName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.isEqual = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    @Override
    public <C> boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitTemplateFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.TEMPLATE_FILTER;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.templateName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isEqual, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.templateName, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isEqual, (OutputStream)stream);
    }
}

