/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.HyperLogLog;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.HyperLogLogStateFactory;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class ApproxCountDistinctAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ApproxCountDistinctAccumulator.class);
    private final TSDataType seriesDataType;
    private final HyperLogLogStateFactory.SingleHyperLogLogState state = HyperLogLogStateFactory.createSingleState();
    private static final int DEFAULT_HYPERLOGLOG_BUCKET_SIZE = 2048;

    public ApproxCountDistinctAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOfInstance(HyperLogLog.class) + 8192L;
    }

    @Override
    public TableAccumulator copy() {
        return new ApproxCountDistinctAccumulator(this.seriesDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        double maxStandardError = arguments.length == 1 ? 0.023 : arguments[1].getDouble(0);
        HyperLogLog hll = ApproxCountDistinctAccumulator.getOrCreateHyperLogLog(this.state, maxStandardError);
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], mask, hll);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], mask, hll);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], mask, hll);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], mask, hll);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], mask, hll);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], mask, hll);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in APPROX_COUNT_DISTINCT Aggregation: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            HyperLogLog current = new HyperLogLog(argument.getBinary(i).getValues());
            this.state.merge(current);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of APPROX_COUNT_DISTINCT should be BinaryColumn");
        columnBuilder.writeBinary(new Binary(this.state.getHyperLogLog().serialize()));
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.state.getHyperLogLog().cardinality());
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException("ApproxCountDistinctAccumulator does not support statistics");
    }

    @Override
    public void reset() {
        this.state.getHyperLogLog().reset();
    }

    public void addBooleanInput(Column valueColumn, AggregationMask mask, HyperLogLog hll) {
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                hll.add(valueColumn.getBoolean(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                hll.add(valueColumn.getBoolean(position));
            }
        }
    }

    public void addIntInput(Column valueColumn, AggregationMask mask, HyperLogLog hll) {
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                hll.add(valueColumn.getInt(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                hll.add(valueColumn.getInt(position));
            }
        }
    }

    public void addLongInput(Column valueColumn, AggregationMask mask, HyperLogLog hll) {
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                hll.add(valueColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                hll.add(valueColumn.getLong(position));
            }
        }
    }

    public void addFloatInput(Column valueColumn, AggregationMask mask, HyperLogLog hll) {
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                hll.add(valueColumn.getFloat(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                hll.add(valueColumn.getFloat(position));
            }
        }
    }

    public void addDoubleInput(Column valueColumn, AggregationMask mask, HyperLogLog hll) {
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                hll.add(valueColumn.getDouble(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                hll.add(valueColumn.getDouble(position));
            }
        }
    }

    public void addBinaryInput(Column valueColumn, AggregationMask mask, HyperLogLog hll) {
        int positionCount = mask.getPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                hll.add(valueColumn.getBinary(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                hll.add(valueColumn.getBinary(position));
            }
        }
    }

    public static HyperLogLog getOrCreateHyperLogLog(HyperLogLogStateFactory.SingleHyperLogLogState state, double maxStandardError) {
        HyperLogLog hll = state.getHyperLogLog();
        if (hll == null) {
            hll = new HyperLogLog(maxStandardError);
            state.setHyperLogLog(hll);
        }
        return hll;
    }
}

