/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.aggregation.TreeAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.window.CountWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.CountWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public class CountWindowManager
implements IWindowManager {
    private final CountWindow countWindow;
    private boolean needSkip;
    private boolean initialized;

    public CountWindowManager(CountWindowParameter countWindowParameter) {
        this.countWindow = new CountWindow(countWindowParameter);
        this.needSkip = false;
    }

    @Override
    public boolean isCurWindowInit() {
        return this.initialized;
    }

    @Override
    public void initCurWindow() {
        this.initialized = true;
        this.countWindow.resetCurCount();
        this.countWindow.setStartTime(Long.MAX_VALUE);
        this.countWindow.setEndTime(Long.MIN_VALUE);
    }

    @Override
    public boolean hasNext(boolean hasMoreData) {
        return hasMoreData;
    }

    @Override
    public void next() {
        this.needSkip = true;
        this.initialized = false;
    }

    @Override
    public IWindow getCurWindow() {
        return this.countWindow;
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        int i;
        if (!this.needSkip) {
            return inputTsBlock;
        }
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        Column timeColumn = inputTsBlock.getTimeColumn();
        Column controlColumn = this.countWindow.getControlColumn(inputTsBlock);
        long leftCount = this.countWindow.getLeftCount();
        int size = inputTsBlock.getPositionCount();
        for (i = 0; i < size && leftCount != 0L; ++i) {
            if (this.isIgnoringNull() && controlColumn.isNull(i)) continue;
            --leftCount;
            long currentTime = timeColumn.getLong(i);
            if (this.countWindow.getStartTime() > currentTime) {
                this.countWindow.setStartTime(currentTime);
            }
            if (this.countWindow.getEndTime() >= currentTime) continue;
            this.countWindow.setEndTime(currentTime);
        }
        this.countWindow.setLeftCount(leftCount);
        if (i < size) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(i);
    }

    @Override
    public TsBlockBuilder createResultTsBlockBuilder(List<TreeAggregator> aggregators) {
        List<TSDataType> dataTypes = this.getResultDataTypes(aggregators);
        if (this.countWindow.isNeedOutputEndTime()) {
            dataTypes.add(0, TSDataType.INT64);
        }
        return new TsBlockBuilder(dataTypes);
    }

    @Override
    public void appendAggregationResult(TsBlockBuilder resultTsBlockBuilder, List<TreeAggregator> aggregators) {
        if (this.countWindow.getLeftCount() != 0L) {
            return;
        }
        long endTime = this.countWindow.isNeedOutputEndTime() ? this.countWindow.getEndTime() : -1L;
        this.outputAggregators(aggregators, resultTsBlockBuilder, this.countWindow.getStartTime(), endTime);
    }

    @Override
    public boolean needSkipInAdvance() {
        return true;
    }

    @Override
    public boolean isIgnoringNull() {
        return this.countWindow.isIgnoreNull();
    }
}

