/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.view.SetViewPropertiesPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.SetViewPropertiesProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.SetTablePropertiesState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTablePropertiesProcedure
extends AbstractAlterOrDropTableProcedure<SetTablePropertiesState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetTablePropertiesProcedure.class);
    private Map<String, String> originalProperties = new HashMap<String, String>();
    private Map<String, String> updatedProperties;

    public SetTablePropertiesProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public SetTablePropertiesProcedure(String database, String tableName, String queryId, Map<String, String> properties, boolean isGeneratedByPipe) {
        super(database, tableName, queryId, isGeneratedByPipe);
        this.updatedProperties = properties;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, SetTablePropertiesState state) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateTable(ConfigNodeProcedureEnv env) {
        try {
            Pair<TSStatus, TsTable> result = env.getConfigManager().getClusterSchemaManager().updateTableProperties(this.database, this.tableName, this.originalProperties, this.updatedProperties, this instanceof SetViewPropertiesProcedure);
            TSStatus status = (TSStatus)result.getLeft();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
                return;
            }
            this.table = (TsTable)result.getRight();
            this.setNextState(SetTablePropertiesState.PRE_RELEASE);
        }
        catch (MetadataException e) {
            this.setFailure(new ProcedureException(e));
        }
    }

    @Override
    protected void preRelease(ConfigNodeProcedureEnv env) {
        super.preRelease(env);
        this.setNextState(SetTablePropertiesState.SET_PROPERTIES);
    }

    private void setProperties(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().executePlan(this instanceof SetViewPropertiesProcedure ? new SetViewPropertiesPlan(this.database, this.tableName, this.updatedProperties) : new SetTablePropertiesPlan(this.database, this.tableName, this.updatedProperties), this.isGeneratedByPipe);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        } else {
            this.setNextState(SetTablePropertiesState.COMMIT_RELEASE);
        }
    }

    @Override
    protected String getActionMessage() {
        return "set table properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, SetTablePropertiesState state) throws IOException, InterruptedException, ProcedureException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case PRE_RELEASE: {
                    LOGGER.info("Start rollback pre release info for table {}.{} when setting properties", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackPreRelease(env);
                    return;
                }
                case SET_PROPERTIES: {
                    LOGGER.info("Start rollback set properties to table {}.{}", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackSetProperties(env);
                    return;
                }
            }
            return;
        }
        finally {
            LOGGER.info("Rollback SetTableProperties-{} costs {}ms.", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void rollbackSetProperties(ConfigNodeProcedureEnv env) {
        if (this.table == null) {
            return;
        }
        TSStatus status = env.getConfigManager().getClusterSchemaManager().executePlan(new SetTablePropertiesPlan(this.database, this.tableName, this.originalProperties), this.isGeneratedByPipe);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected SetTablePropertiesState getState(int stateId) {
        return SetTablePropertiesState.values()[stateId];
    }

    @Override
    protected int getStateId(SetTablePropertiesState state) {
        return state.ordinal();
    }

    @Override
    protected SetTablePropertiesState getInitialState() {
        return SetTablePropertiesState.VALIDATE_TABLE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_SET_TABLE_PROPERTIES_PROCEDURE.getTypeCode() : ProcedureType.SET_TABLE_PROPERTIES_PROCEDURE.getTypeCode());
        this.innerSerialize(stream);
    }

    protected void innerSerialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write(this.originalProperties, (OutputStream)stream);
        ReadWriteIOUtils.write(this.updatedProperties, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.originalProperties = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        this.updatedProperties = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.updatedProperties, ((SetTablePropertiesProcedure)o).updatedProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.updatedProperties);
    }
}

