/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class ColumnDefinition
extends Node {
    private final Identifier name;
    private final DataType type;
    private final TsTableColumnCategory columnCategory;
    @Nullable
    private final String charsetName;
    @Nullable
    private final String comment;

    public ColumnDefinition(@Nullable NodeLocation location, Identifier name, DataType type, TsTableColumnCategory columnCategory, @Nullable String charsetName, @Nullable String comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.columnCategory = Objects.requireNonNull(columnCategory, "columnCategory is null");
        this.type = this.getDefaultType(type);
        this.charsetName = charsetName;
        this.comment = comment;
    }

    protected DataType getDefaultType(DataType type) {
        if (Objects.isNull(type)) {
            if (this.columnCategory == TsTableColumnCategory.TAG || this.columnCategory == TsTableColumnCategory.ATTRIBUTE) {
                return new GenericDataType(new Identifier("string"), new ArrayList<DataTypeParameter>());
            }
            if (this.columnCategory == TsTableColumnCategory.TIME) {
                return new GenericDataType(new Identifier("timestamp"), new ArrayList<DataTypeParameter>());
            }
        }
        return type;
    }

    public Identifier getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public TsTableColumnCategory getColumnCategory() {
        return this.columnCategory;
    }

    public Optional<String> getCharsetName() {
        return Optional.ofNullable(this.charsetName);
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnDefinition(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && this.columnCategory == that.columnCategory && Objects.equals(this.charsetName, that.charsetName) && Objects.equals(this.comment, that.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type, this.columnCategory, this.charsetName, this.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("columnCategory", (Object)this.columnCategory).add("charsetName", (Object)this.charsetName).add("comment", (Object)this.comment).toString();
    }
}

