/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;

public class StackableAstVisitor<R, C>
extends AstVisitor<R, StackableAstVisitorContext<C>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R process(Node node, StackableAstVisitorContext<C> context) {
        context.push(node);
        try {
            Object r = node.accept(this, context);
            return r;
        }
        finally {
            ((StackableAstVisitorContext)context).pop();
        }
    }

    public static class StackableAstVisitorContext<C> {
        private final LinkedList<Node> stack = new LinkedList();
        private final C context;

        public StackableAstVisitorContext(C context) {
            this.context = context;
        }

        public C getContext() {
            return this.context;
        }

        private void pop() {
            this.stack.pop();
        }

        void push(Node node) {
            this.stack.push(node);
        }

        public Optional<Node> getPreviousNode() {
            if (this.stack.size() > 1) {
                return Optional.of(this.stack.get(1));
            }
            return Optional.empty();
        }
    }
}

