/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.retention.RetentionPolicy;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.retention.RetentionPolicyImpl;

public class TestContentLoader {
    private static final Charset ENCODING = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTestContent(Session session) throws RepositoryException, IOException {
        JackrabbitNodeTypeManager manager;
        JackrabbitWorkspace workspace = (JackrabbitWorkspace)session.getWorkspace();
        List<String> workspaces = Arrays.asList(workspace.getAccessibleWorkspaceNames());
        if (!workspaces.contains("test")) {
            workspace.createWorkspace("test");
        }
        if (!(manager = (JackrabbitNodeTypeManager)workspace.getNodeTypeManager()).hasNodeType("test:versionable")) {
            try (InputStream xml = TestContentLoader.class.getResourceAsStream("test-nodetypes.xml");){
                manager.registerNodeTypes(xml, "text/xml");
            }
        }
        Node data = this.getOrAddNode(session.getRootNode(), "testdata");
        this.addPropertyTestData(this.getOrAddNode(data, "property"));
        this.addQueryTestData(this.getOrAddNode(data, "query"));
        this.addNodeTestData(this.getOrAddNode(data, "node"));
        this.addLifecycleTestData(this.getOrAddNode(data, "lifecycle"));
        this.addExportTestData(this.getOrAddNode(data, "docViewTest"));
        Node conf = this.getOrAddNode(session.getRootNode(), "testconf");
        this.addRetentionTestData(this.getOrAddNode(conf, "retentionTest"));
        session.save();
    }

    private Node getOrAddNode(Node node, String name) throws RepositoryException {
        try {
            return node.getNode(name);
        }
        catch (PathNotFoundException e) {
            return node.addNode(name);
        }
    }

    private void addPropertyTestData(Node node) throws RepositoryException {
        node.setProperty("boolean", true);
        node.setProperty("double", Math.PI);
        node.setProperty("long", 90834953485278298L);
        Calendar c = Calendar.getInstance();
        c.set(2005, 6, 18, 17, 30);
        node.setProperty("calendar", c);
        ValueFactory factory = node.getSession().getValueFactory();
        node.setProperty("path", factory.createValue("/", 8));
        node.setProperty("multi", new String[]{"one", "two", "three"});
    }

    private void addRetentionTestData(Node node) throws RepositoryException {
        RetentionPolicy rp = RetentionPolicyImpl.createRetentionPolicy("testRetentionPolicy", node.getSession());
        node.getSession().getRetentionManager().setRetentionPolicy(node.getPath(), rp);
    }

    private void addQueryTestData(Node node) throws RepositoryException {
        while (node.hasNode("node1")) {
            node.getNode("node1").remove();
        }
        this.getOrAddNode(node, "node1").setProperty("prop1", "You can have it good, cheap, or fast. Any two.");
        this.getOrAddNode(node, "node1").setProperty("prop1", "foo bar");
        this.getOrAddNode(node, "node1").setProperty("prop1", "Hello world!");
        this.getOrAddNode(node, "node2").setProperty("prop1", "Apache Jackrabbit");
    }

    private void addNodeTestData(Node node) throws RepositoryException, IOException {
        if (node.hasNode("multiReference")) {
            node.getNode("multiReference").remove();
        }
        if (node.hasNode("resReference")) {
            node.getNode("resReference").remove();
        }
        if (node.hasNode("myResource")) {
            node.getNode("myResource").remove();
        }
        Node resource = node.addNode("myResource", "nt:resource");
        resource.addMixin("mix:referenceable");
        resource.setProperty("jcr:encoding", ENCODING.name());
        resource.setProperty("jcr:mimeType", "text/plain");
        resource.setProperty("jcr:data", new ByteArrayInputStream("Hello w\u00f6rld.".getBytes(ENCODING)));
        resource.setProperty("jcr:lastModified", Calendar.getInstance());
        Node resReference = this.getOrAddNode(node, "reference");
        resReference.setProperty("ref", resource);
        resReference.addMixin("mix:referenceable");
        Node multiReference = node.addNode("multiReference");
        ValueFactory factory = node.getSession().getValueFactory();
        multiReference.setProperty("ref", new Value[]{factory.createValue(resource), factory.createValue(resReference)});
        JcrUtils.putFile(node, "testFile", "text/plain", new ByteArrayInputStream("Hello, World!".getBytes(StandardCharsets.UTF_8)));
    }

    private void addLifecycleTestData(Node node) throws RepositoryException {
        Node policy = this.getOrAddNode(node, "policy");
        policy.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        Node transitions = this.getOrAddNode(policy, "transitions");
        Node transition = this.getOrAddNode(transitions, "identity");
        transition.setProperty("from", "identity");
        transition.setProperty("to", "identity");
        Node lifecycle = this.getOrAddNode(node, "node");
        ((NodeImpl)lifecycle).assignLifecyclePolicy(policy, "identity");
    }

    private void addExportTestData(Node node) throws RepositoryException, IOException {
        this.getOrAddNode(node, "invalidXmlName").setProperty("propName", "some text");
        this.getOrAddNode(node, "jcr:xmltext").setProperty("jcr:xmlcharacters", "A text without any special character.");
        this.getOrAddNode(node, "some-element");
        this.getOrAddNode(node, "jcr:xmltext").setProperty("jcr:xmlcharacters", " The entity reference characters: <, ', ,&, >,  \" should be escaped in xml export. ");
        this.getOrAddNode(node, "some-element");
        this.getOrAddNode(node, "jcr:xmltext").setProperty("jcr:xmlcharacters", "A text without any special character.");
        Node big = this.getOrAddNode(node, "bigNode");
        big.setProperty("propName0", "SGVsbG8gd8O2cmxkLg==;SGVsbG8gd8O2cmxkLg==".split(";"), 2);
        big.setProperty("propName1", "text 1");
        big.setProperty("propName2", "multival text 1;multival text 2;multival text 3".split(";"));
        big.setProperty("propName3", "text 1");
        this.addExportValues(node, "propName");
        this.addExportValues(node, "Prop<>prop");
    }

    private void addExportValues(Node node, String name) throws RepositoryException, IOException {
        String prefix = "valid";
        if (name.indexOf(60) != -1) {
            prefix = "invalid";
        }
        node = this.getOrAddNode(node, prefix + "Names");
        String[] texts = new String[]{"multival text 1", "multival text 2", "multival text 3"};
        this.getOrAddNode(node, prefix + "MultiNoBin").setProperty(name, texts);
        Node resource = this.getOrAddNode(node, prefix + "MultiBin");
        resource.setProperty("jcr:encoding", ENCODING.name());
        resource.setProperty("jcr:mimeType", "text/plain");
        String[] values = new String[]{"SGVsbG8gd8O2cmxkLg==", "SGVsbG8gd8O2cmxkLg=="};
        resource.setProperty(name, values, 2);
        resource.setProperty("jcr:lastModified", Calendar.getInstance());
        this.getOrAddNode(node, prefix + "NoBin").setProperty(name, "text 1");
        resource = this.getOrAddNode(node, "invalidBin");
        resource.setProperty("jcr:encoding", ENCODING.name());
        resource.setProperty("jcr:mimeType", "text/plain");
        byte[] bytes = "Hello w\u00f6rld.".getBytes(ENCODING);
        resource.setProperty(name, new ByteArrayInputStream(bytes));
        resource.setProperty("jcr:lastModified", Calendar.getInstance());
    }
}

