/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.DefaultSecurityManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.config.UserManagerConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.DefaultPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.GroupPrincipals;
import org.apache.jackrabbit.core.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.user.MembershipCache;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.security.user.UserPerWorkspaceUserManager;
import org.apache.jackrabbit.core.security.user.action.AuthorizableAction;

public class UserPerWorkspaceSecurityManager
extends DefaultSecurityManager {
    private final Map<String, PrincipalProviderRegistry> ppRegistries = new HashMap<String, PrincipalProviderRegistry>();
    private final Object monitor = new Object();
    private final List<String> systemUsersInitialized = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalProviderRegistry getPrincipalProviderRegistry(SessionImpl s) throws RepositoryException {
        String wspName = s.getWorkspace().getName();
        Object object = this.monitor;
        synchronized (object) {
            PrincipalProviderRegistry p = this.ppRegistries.get(wspName);
            if (p == null) {
                SystemSession systemSession;
                if (s instanceof SystemSession) {
                    systemSession = (SystemSession)s;
                } else {
                    RepositoryImpl repo = (RepositoryImpl)this.getRepository();
                    systemSession = repo.getSystemSession(wspName);
                    repo.markWorkspaceActive(wspName);
                }
                Properties[] moduleConfig = new AuthContextProvider("", ((RepositoryImpl)this.getRepository()).getConfig().getSecurityConfig().getLoginModuleConfig()).getModuleConfig();
                DefaultPrincipalProvider defaultPP = new DefaultPrincipalProvider(systemSession, (UserManagerImpl)this.getUserManager(systemSession));
                boolean initialized = false;
                for (Properties props : moduleConfig) {
                    if (props.containsKey("principalProvider") || !props.containsKey("cacheMaxSize")) continue;
                    defaultPP.init(props);
                    initialized = true;
                    break;
                }
                if (!initialized) {
                    defaultPP.init(new Properties());
                }
                p = new WorkspaceBasedPrincipalProviderRegistry(defaultPP);
                this.ppRegistries.put(wspName, p);
            }
            return p;
        }
    }

    @Override
    public void init(Repository repository, Session systemSession) throws RepositoryException {
        super.init(repository, systemSession);
        this.systemUsersInitialized.add(systemSession.getWorkspace().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(String workspaceName) {
        super.dispose(workspaceName);
        Object object = this.monitor;
        synchronized (object) {
            PrincipalProviderRegistry reg = this.ppRegistries.remove(workspaceName);
            if (reg != null) {
                reg.getDefault().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.monitor;
        synchronized (object) {
            for (PrincipalProviderRegistry registry : this.ppRegistries.values()) {
                registry.getDefault().close();
            }
            this.ppRegistries.clear();
        }
    }

    @Override
    public UserManager getUserManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session == this.getSystemSession()) {
            return super.getUserManager(session);
        }
        if (session instanceof SessionImpl) {
            UserManagerImpl uMgr = this.createUserManager((SessionImpl)session);
            String wspName = session.getWorkspace().getName();
            if (session instanceof SystemSession && !this.systemUsersInitialized.contains(wspName)) {
                UserPerWorkspaceSecurityManager.createSystemUsers(uMgr, (SystemSession)session, this.adminId, this.anonymousId);
                this.systemUsersInitialized.add(wspName);
            }
            return uMgr;
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    @Override
    public AuthContext getAuthContext(Credentials creds, Subject subject, String workspaceName) throws RepositoryException {
        this.checkInitialized();
        SystemSession systemSession = ((RepositoryImpl)this.getRepository()).getSystemSession(workspaceName);
        return this.getAuthContextProvider().getAuthContext(creds, subject, systemSession, this.getPrincipalProviderRegistry(systemSession), this.adminId, this.anonymousId);
    }

    @Override
    protected PrincipalProvider createDefaultPrincipalProvider(Properties[] moduleConfig) throws RepositoryException {
        return null;
    }

    @Override
    protected UserManager getSystemUserManager(String workspaceName) throws RepositoryException {
        if (workspaceName.equals(this.getSystemSession().getWorkspace().getName())) {
            return super.getSystemUserManager(workspaceName);
        }
        return ((RepositoryImpl)this.getRepository()).getWorkspaceInfo(workspaceName).getSystemSession().getUserManager();
    }

    @Override
    protected UserManagerImpl createUserManager(SessionImpl session) throws RepositoryException {
        UserPerWorkspaceUserManager umgr;
        UserManagerConfig umc = this.getConfig().getUserManagerConfig();
        if (umc != null) {
            Class[] paramTypes = new Class[]{SessionImpl.class, String.class, Properties.class, MembershipCache.class};
            umgr = (UserPerWorkspaceUserManager)umc.getUserManager(UserPerWorkspaceUserManager.class, paramTypes, session, this.adminId, umc.getParameters(), this.getMembershipCache(session));
        } else {
            umgr = new UserPerWorkspaceUserManager(session, this.adminId, null, this.getMembershipCache(session));
        }
        if (umc != null && !(session instanceof SystemSession)) {
            AuthorizableAction[] actions = umc.getAuthorizableActions();
            umgr.setAuthorizableActions(actions);
        }
        return umgr;
    }

    @Override
    protected PrincipalManager createPrincipalManager(SessionImpl session) throws RepositoryException {
        return new PrincipalManagerImpl(session, this.getPrincipalProviderRegistry(session).getProviders());
    }

    @Override
    protected WorkspaceAccessManager createDefaultWorkspaceAccessManager() {
        return new WorkspaceAccessManagerImpl();
    }

    private final class WorkspaceBasedPrincipalProviderRegistry
    implements PrincipalProviderRegistry {
        private final PrincipalProvider defaultPrincipalProvider;

        public WorkspaceBasedPrincipalProviderRegistry(PrincipalProvider defaultPrincipalProvider) {
            this.defaultPrincipalProvider = defaultPrincipalProvider;
        }

        @Override
        public PrincipalProvider registerProvider(Properties configuration) throws RepositoryException {
            return UserPerWorkspaceSecurityManager.this.getPrincipalProviderRegistry().registerProvider(configuration);
        }

        @Override
        public PrincipalProvider getDefault() {
            return this.defaultPrincipalProvider;
        }

        @Override
        public PrincipalProvider getProvider(String className) {
            PrincipalProvider p = UserPerWorkspaceSecurityManager.this.getPrincipalProviderRegistry().getProvider(className);
            if (p == null && this.defaultPrincipalProvider.getClass().getName().equals(className)) {
                p = this.defaultPrincipalProvider;
            }
            return p;
        }

        @Override
        public PrincipalProvider[] getProviders() {
            ArrayList<PrincipalProvider> l = new ArrayList<PrincipalProvider>();
            l.addAll(Arrays.asList(UserPerWorkspaceSecurityManager.this.getPrincipalProviderRegistry().getProviders()));
            l.add(this.defaultPrincipalProvider);
            return l.toArray(new PrincipalProvider[l.size()]);
        }
    }

    private final class WorkspaceAccessManagerImpl
    implements WorkspaceAccessManager {
        private WorkspaceAccessManagerImpl() {
        }

        @Override
        public void init(Session systemSession) throws RepositoryException {
        }

        @Override
        public void close() throws RepositoryException {
        }

        @Override
        public boolean grants(Set<Principal> principals, String workspaceName) throws RepositoryException {
            if (!Arrays.asList(((RepositoryImpl)UserPerWorkspaceSecurityManager.this.getRepository()).getWorkspaceNames()).contains(workspaceName)) {
                return false;
            }
            UserManager umgr = UserPerWorkspaceSecurityManager.this.getSystemUserManager(workspaceName);
            for (Principal principal : principals) {
                if (GroupPrincipals.isGroup(principal) || umgr.getAuthorizable(principal) == null) continue;
                return true;
            }
            return false;
        }
    }
}

