/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InconsistentVersioningState;
import org.apache.jackrabbit.core.version.InternalActivityImpl;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersioningLock;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalVersionImpl
extends InternalVersionItemImpl
implements InternalVersion {
    private static final Logger log = LoggerFactory.getLogger(InternalVersionImpl.class);
    private Calendar created;
    private HashSet<Name> labelCache = null;
    private final boolean isRoot;
    private final Name name;
    private final InternalVersionHistory versionHistory;

    public InternalVersionImpl(InternalVersionHistoryImpl vh, NodeStateEx node, Name name) throws RepositoryException {
        super(vh.getVersionManager(), node);
        this.versionHistory = vh;
        this.name = name;
        InternalValue[] values = node.getPropertyValues(NameConstants.JCR_CREATED);
        if (values != null) {
            this.created = values[0].getDate();
        }
        this.isRoot = name.equals(NameConstants.JCR_ROOTVERSION);
    }

    @Override
    public NodeId getId() {
        return this.node.getNodeId();
    }

    @Override
    public InternalVersionItem getParent() {
        return this.versionHistory;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public InternalFrozenNode getFrozenNode() {
        try {
            return (InternalFrozenNode)this.vMgr.getItem(this.getFrozenNodeId());
        }
        catch (RepositoryException e) {
            throw new InconsistentVersioningState("unable to retrieve frozen node: " + String.valueOf(e), null, e);
        }
    }

    @Override
    public NodeId getFrozenNodeId() {
        ChildNodeEntry entry = this.node.getState().getChildNodeEntry(NameConstants.JCR_FROZENNODE, 1);
        if (entry == null) {
            throw new InconsistentVersioningState("version has no frozen node: " + String.valueOf(this.getId()));
        }
        return entry.getId();
    }

    @Override
    public Calendar getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InternalVersion> getSuccessors() {
        VersioningLock.ReadLock lock = this.vMgr.acquireReadLock();
        try {
            InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_SUCCESSORS);
            if (values != null) {
                ArrayList<InternalVersion> versions = new ArrayList<InternalVersion>(values.length);
                for (InternalValue value : values) {
                    InternalVersion version = this.versionHistory.getVersion(value.getNodeId());
                    if (version != null) {
                        versions.add(version);
                        continue;
                    }
                    log.warn("Missing successor {}", (Object)value.getNodeId());
                }
                ArrayList<InternalVersion> arrayList = versions;
                return arrayList;
            }
            List<InternalVersion> list = Collections.emptyList();
            return list;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public InternalVersion getLinearSuccessor(InternalVersion baseVersion) {
        InternalVersion pred = baseVersion.getLinearPredecessor();
        while (pred != null && !pred.getId().equals(this.getId())) {
            baseVersion = pred;
            pred = baseVersion.getLinearPredecessor();
        }
        return pred == null ? null : baseVersion;
    }

    @Override
    public InternalVersion[] getPredecessors() {
        InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_PREDECESSORS);
        if (values != null) {
            InternalVersion[] versions = new InternalVersion[values.length];
            for (int i = 0; i < values.length; ++i) {
                versions[i] = this.versionHistory.getVersion(values[i].getNodeId());
            }
            return versions;
        }
        return new InternalVersion[0];
    }

    @Override
    public InternalVersion getLinearPredecessor() {
        InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_PREDECESSORS);
        if (values != null && values.length > 0) {
            return this.versionHistory.getVersion(values[0].getNodeId());
        }
        return null;
    }

    @Override
    public boolean isMoreRecent(InternalVersion v) {
        InternalVersion[] preds;
        for (InternalVersion pred : preds = this.getPredecessors()) {
            if (!pred.equals(v) && !pred.isMoreRecent(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InternalVersionHistory getVersionHistory() {
        return this.versionHistory;
    }

    @Override
    public boolean hasLabel(Name label) {
        return this.internalHasLabel(label);
    }

    @Override
    public Name[] getLabels() {
        return this.internalGetLabels();
    }

    @Override
    public boolean isRootVersion() {
        return this.isRoot;
    }

    synchronized void clear() {
        this.labelCache = null;
    }

    private void storeXCessors(List<InternalVersion> cessors, Name propname, boolean store) throws RepositoryException {
        InternalValue[] values = new InternalValue[cessors.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = InternalValue.create(cessors.get(i).getId());
        }
        this.node.setPropertyValues(propname, 9, values);
        if (store) {
            this.node.store();
        }
    }

    void internalDetach() throws RepositoryException {
        InternalVersion[] preds;
        for (InternalVersion aSucc : this.getSuccessors()) {
            ((InternalVersionImpl)aSucc).internalDetachPredecessor(this, true);
        }
        for (InternalVersion pred : preds = this.getPredecessors()) {
            ((InternalVersionImpl)pred).internalDetachSuccessor(this, true);
        }
        this.clear();
    }

    void internalAttach() throws RepositoryException {
        InternalVersion[] preds;
        for (InternalVersion pred : preds = this.getPredecessors()) {
            ((InternalVersionImpl)pred).internalAddSuccessor(this, true);
        }
    }

    private void internalAddSuccessor(InternalVersionImpl succ, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(this.getSuccessors());
        if (!l.contains(succ)) {
            l.add(succ);
            this.storeXCessors(l, NameConstants.JCR_SUCCESSORS, store);
        }
    }

    private void internalDetachPredecessor(InternalVersionImpl v, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(Arrays.asList(this.getPredecessors()));
        l.remove(v);
        l.addAll(Arrays.asList(v.getPredecessors()));
        this.storeXCessors(l, NameConstants.JCR_PREDECESSORS, store);
    }

    private void internalDetachSuccessor(InternalVersionImpl v, boolean store) throws RepositoryException {
        ArrayList<InternalVersion> l = new ArrayList<InternalVersion>(this.getSuccessors());
        l.remove(v);
        l.addAll(v.getSuccessors());
        this.storeXCessors(l, NameConstants.JCR_SUCCESSORS, store);
    }

    synchronized boolean internalAddLabel(Name label) {
        if (this.labelCache == null) {
            this.labelCache = new HashSet();
        }
        return this.labelCache.add(label);
    }

    synchronized boolean internalRemoveLabel(Name label) {
        return this.labelCache != null && this.labelCache.remove(label);
    }

    synchronized boolean internalHasLabel(Name label) {
        return this.labelCache != null && this.labelCache.contains(label);
    }

    synchronized Name[] internalGetLabels() {
        if (this.labelCache == null) {
            return Name.EMPTY_ARRAY;
        }
        return this.labelCache.toArray(new Name[this.labelCache.size()]);
    }

    void invalidate() {
        this.node.getState().discard();
    }

    void legacyResolveSuccessors() throws RepositoryException {
        InternalValue[] values = this.node.getPropertyValues(NameConstants.JCR_PREDECESSORS);
        if (values != null) {
            for (InternalValue value : values) {
                InternalVersionImpl v = (InternalVersionImpl)this.versionHistory.getVersion(value.getNodeId());
                if (v == null) continue;
                v.internalAddSuccessor(this, false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InternalVersionImpl) {
            InternalVersionImpl v = (InternalVersionImpl)obj;
            return v.getId().equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public InternalActivityImpl getActivity() throws RepositoryException {
        if (this.node.hasProperty(NameConstants.JCR_ACTIVITY)) {
            InternalValue value = this.node.getPropertyValue(NameConstants.JCR_ACTIVITY);
            return (InternalActivityImpl)this.vMgr.getItem(value.getNodeId());
        }
        return null;
    }
}

