/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefinitionValidator {
    private static Logger log = LoggerFactory.getLogger(DefinitionValidator.class);
    private final EffectiveNodeTypeProvider entProvider;
    private final NamespaceRegistry nsRegistry;

    DefinitionValidator(EffectiveNodeTypeProvider entProvider, NamespaceRegistry nsRegistry) {
        this.entProvider = entProvider;
        this.nsRegistry = nsRegistry;
    }

    public Map<QNodeTypeDefinition, EffectiveNodeType> validateNodeTypeDefs(Collection<QNodeTypeDefinition> ntDefs, Map<Name, QNodeTypeDefinition> validatedDefs) throws InvalidNodeTypeDefinitionException, RepositoryException {
        HashMap<Name, QNodeTypeDefinition> tmpMap = new HashMap<Name, QNodeTypeDefinition>(validatedDefs);
        for (QNodeTypeDefinition ntd : ntDefs) {
            tmpMap.put(ntd.getName(), ntd);
        }
        HashMap<QNodeTypeDefinition, EffectiveNodeType> ntMap = new HashMap<QNodeTypeDefinition, EffectiveNodeType>();
        ArrayList<QNodeTypeDefinition> list = new ArrayList<QNodeTypeDefinition>(ntDefs);
        int count = -1;
        while (list.size() > 0 && count != 0) {
            count = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                QNodeTypeDefinition ntd = (QNodeTypeDefinition)iterator.next();
                Collection<Name> dependencies = ntd.getDependencies();
                if (!tmpMap.keySet().containsAll(dependencies)) continue;
                EffectiveNodeType ent = this.validateNodeTypeDef(ntd, tmpMap);
                ntMap.put(ntd, ent);
                iterator.remove();
                ++count;
            }
        }
        if (list.size() > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("the following node types could not be registered because of unresolvable dependencies: ");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                msg.append(((QNodeTypeDefinition)iterator.next()).getName());
                msg.append(" ");
            }
            log.error(msg.toString());
            throw new InvalidNodeTypeDefinitionException(msg.toString());
        }
        return ntMap;
    }

    public EffectiveNodeType validateNodeTypeDef(QNodeTypeDefinition ntDef, Map<Name, QNodeTypeDefinition> validatedDefs) throws InvalidNodeTypeDefinitionException, RepositoryException {
        String msg;
        Name name;
        EffectiveNodeType ent;
        block38: {
            ent = null;
            name = ntDef.getName();
            if (name == null) {
                String msg2 = "no name specified";
                log.debug(msg2);
                throw new InvalidNodeTypeDefinitionException(msg2);
            }
            this.checkNamespace(name);
            Name[] supertypes = ntDef.getSupertypes();
            if (supertypes.length > 0) {
                for (int i = 0; i < supertypes.length; ++i) {
                    this.checkNamespace(supertypes[i]);
                    if (name.equals(supertypes[i])) {
                        String msg3 = "[" + String.valueOf(name) + "] invalid supertype: " + String.valueOf(supertypes[i]) + " (infinite recursion))";
                        log.debug(msg3);
                        throw new InvalidNodeTypeDefinitionException(msg3);
                    }
                    if (validatedDefs.containsKey(supertypes[i])) continue;
                    String msg4 = "[" + String.valueOf(name) + "] invalid supertype: " + String.valueOf(supertypes[i]);
                    log.debug(msg4);
                    throw new InvalidNodeTypeDefinitionException(msg4);
                }
                Stack<Name> inheritanceChain = new Stack<Name>();
                inheritanceChain.push(name);
                this.checkForCircularInheritance(supertypes, inheritanceChain, validatedDefs);
            }
            if (supertypes.length > 0) {
                try {
                    EffectiveNodeType est = this.entProvider.getEffectiveNodeType(supertypes, validatedDefs);
                    if (!(ntDef.isMixin() || NameConstants.NT_BASE.equals(ntDef.getName()) || est.includesNodeType(NameConstants.NT_BASE))) {
                        String msg5 = "[" + String.valueOf(name) + "] all primary node types except nt:base itself must be (directly or indirectly) derived from nt:base";
                        log.debug(msg5);
                        throw new InvalidNodeTypeDefinitionException(msg5);
                    }
                    break block38;
                }
                catch (ConstraintViolationException e) {
                    String msg6 = "[" + String.valueOf(name) + "] failed to validate supertypes";
                    log.debug(msg6);
                    throw new InvalidNodeTypeDefinitionException(msg6, e);
                }
                catch (NoSuchNodeTypeException e) {
                    String msg7 = "[" + String.valueOf(name) + "] failed to validate supertypes";
                    log.debug(msg7);
                    throw new InvalidNodeTypeDefinitionException(msg7, e);
                }
            }
            if (!ntDef.isMixin() && !NameConstants.NT_BASE.equals(ntDef.getName())) {
                String msg8 = "[" + String.valueOf(name) + "] all primary node types except nt:base itself must be (directly or indirectly) derived from nt:base";
                log.debug(msg8);
                throw new InvalidNodeTypeDefinitionException(msg8);
            }
        }
        this.checkNamespace(ntDef.getPrimaryItemName());
        QPropertyDefinition[] pda = ntDef.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            QPropertyDefinition pd = pda[i];
            if (!name.equals(pd.getDeclaringNodeType())) {
                msg = "[" + String.valueOf(name) + "#" + String.valueOf(pd.getName()) + "] invalid declaring node type specified";
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg);
            }
            this.checkNamespace(pd.getName());
            if (pd.definesResidual() && pd.isAutoCreated()) {
                msg = "[" + String.valueOf(name) + "#" + String.valueOf(pd.getName()) + "] auto-created properties must specify a name";
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg);
            }
            if (pd.getRequiredType() == 0 && pd.isAutoCreated()) {
                msg = "[" + String.valueOf(name) + "#" + String.valueOf(pd.getName()) + "] auto-created properties must specify a type";
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg);
            }
            QValue[] defVals = pd.getDefaultValues();
            ValueConstraint.checkValueConstraints(pd, defVals);
            QValueConstraint[] constraints = pd.getValueConstraints();
            if (constraints == null || constraints.length <= 0 || pd.getRequiredType() != 9) continue;
            for (QValueConstraint constraint : constraints) {
                Name ntName = NameFactoryImpl.getInstance().create(constraint.getString());
                if (name.equals(ntName) || validatedDefs.containsKey(ntName)) continue;
                String msg9 = "[" + String.valueOf(name) + "#" + String.valueOf(pd.getName()) + "] invalid REFERENCE value constraint '" + String.valueOf(ntName) + "' (unknown node type)";
                log.debug(msg9);
                throw new InvalidNodeTypeDefinitionException(msg9);
            }
        }
        QNodeDefinition[] cnda = ntDef.getChildNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            Name[] reqTypes;
            String msg10;
            QNodeDefinition cnd = cnda[i];
            if (!name.equals(cnd.getDeclaringNodeType())) {
                msg10 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] invalid declaring node type specified";
                log.debug(msg10);
                throw new InvalidNodeTypeDefinitionException(msg10);
            }
            this.checkNamespace(cnd.getName());
            if (cnd.definesResidual() && cnd.isAutoCreated()) {
                msg10 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] auto-created child-nodes must specify a name";
                log.debug(msg10);
                throw new InvalidNodeTypeDefinitionException(msg10);
            }
            if (cnd.getDefaultPrimaryType() == null && cnd.isAutoCreated()) {
                msg10 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] auto-created child-nodes must specify a default primary type";
                log.debug(msg10);
                throw new InvalidNodeTypeDefinitionException(msg10);
            }
            Name dpt = cnd.getDefaultPrimaryType();
            this.checkNamespace(dpt);
            boolean referenceToSelf = false;
            EffectiveNodeType defaultENT = null;
            if (dpt != null) {
                if (name.equals(dpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(dpt) && !validatedDefs.containsKey(dpt)) {
                    String msg11 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] invalid default primary type '" + String.valueOf(dpt) + "'";
                    log.debug(msg11);
                    throw new InvalidNodeTypeDefinitionException(msg11);
                }
                try {
                    defaultENT = !referenceToSelf ? this.entProvider.getEffectiveNodeType(new Name[]{dpt}, validatedDefs) : (ent = this.entProvider.getEffectiveNodeType(ntDef, validatedDefs));
                    if (cnd.isAutoCreated()) {
                        Stack<Name> definingNTs = new Stack<Name>();
                        definingNTs.push(name);
                        this.checkForCircularNodeAutoCreation(defaultENT, definingNTs, validatedDefs);
                    }
                }
                catch (ConstraintViolationException e) {
                    String msg12 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] failed to validate default primary type";
                    log.debug(msg12);
                    throw new InvalidNodeTypeDefinitionException(msg12, e);
                }
                catch (NoSuchNodeTypeException e) {
                    String msg13 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] failed to validate default primary type";
                    log.debug(msg13);
                    throw new InvalidNodeTypeDefinitionException(msg13, e);
                }
            }
            if ((reqTypes = cnd.getRequiredPrimaryTypes()) == null || reqTypes.length <= 0) continue;
            for (int n = 0; n < reqTypes.length; ++n) {
                Name rpt = reqTypes[n];
                this.checkNamespace(rpt);
                referenceToSelf = false;
                if (name.equals(rpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(rpt) && !validatedDefs.containsKey(rpt)) {
                    String msg14 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] invalid required primary type: " + String.valueOf(rpt);
                    log.debug(msg14);
                    throw new InvalidNodeTypeDefinitionException(msg14);
                }
                if (defaultENT != null && !defaultENT.includesNodeType(rpt)) {
                    String msg15 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] default primary type does not satisfy required primary type constraint " + String.valueOf(rpt);
                    log.debug(msg15);
                    throw new InvalidNodeTypeDefinitionException(msg15);
                }
                try {
                    if (!referenceToSelf) {
                        this.entProvider.getEffectiveNodeType(new Name[]{rpt}, validatedDefs);
                        continue;
                    }
                    if (ent != null) continue;
                    ent = this.entProvider.getEffectiveNodeType(ntDef, validatedDefs);
                    continue;
                }
                catch (ConstraintViolationException e) {
                    String msg16 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] failed to validate required primary type constraint";
                    log.debug(msg16);
                    throw new InvalidNodeTypeDefinitionException(msg16, e);
                }
                catch (NoSuchNodeTypeException e) {
                    String msg17 = "[" + String.valueOf(name) + "#" + String.valueOf(cnd.getName()) + "] failed to validate required primary type constraint";
                    log.debug(msg17);
                    throw new InvalidNodeTypeDefinitionException(msg17, e);
                }
            }
        }
        if (ent == null) {
            try {
                ent = this.entProvider.getEffectiveNodeType(ntDef, validatedDefs);
            }
            catch (ConstraintViolationException e) {
                msg = "[" + String.valueOf(name) + "] failed to resolve node type definition";
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg, e);
            }
            catch (NoSuchNodeTypeException e) {
                msg = "[" + String.valueOf(name) + "] failed to resolve node type definition";
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg, e);
            }
        }
        return ent;
    }

    private void checkForCircularInheritance(Name[] supertypes, Stack<Name> inheritanceChain, Map<Name, QNodeTypeDefinition> ntdMap) throws InvalidNodeTypeDefinitionException, RepositoryException {
        for (int i = 0; i < supertypes.length; ++i) {
            Name stName = supertypes[i];
            int pos = inheritanceChain.lastIndexOf(stName);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < inheritanceChain.size(); ++j) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append(inheritanceChain.get(j));
                    buf.append(" extends ");
                }
                buf.append("--> ");
                buf.append(stName);
                throw new InvalidNodeTypeDefinitionException("circular inheritance detected: " + buf.toString());
            }
            if (ntdMap.containsKey(stName)) {
                Name[] sta = ntdMap.get(stName).getSupertypes();
                if (sta.length <= 0) continue;
                inheritanceChain.push(stName);
                this.checkForCircularInheritance(sta, inheritanceChain, ntdMap);
                inheritanceChain.pop();
                continue;
            }
            throw new InvalidNodeTypeDefinitionException("Unknown supertype: " + String.valueOf(stName));
        }
    }

    private void checkForCircularNodeAutoCreation(EffectiveNodeType childNodeENT, Stack<Name> definingParentNTs, Map<Name, QNodeTypeDefinition> ntdMap) throws InvalidNodeTypeDefinitionException {
        Name[] childNodeNTs = childNodeENT.getAllNodeTypes();
        for (int i = 0; i < childNodeNTs.length; ++i) {
            Name nt = childNodeNTs[i];
            int pos = definingParentNTs.lastIndexOf(nt);
            if (pos < 0) continue;
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < definingParentNTs.size(); ++j) {
                if (j == pos) {
                    buf.append("--> ");
                }
                buf.append("node type ");
                buf.append(definingParentNTs.get(j));
                buf.append(" defines auto-created child node with default ");
            }
            buf.append("--> ");
            buf.append("node type ");
            buf.append(nt);
            throw new InvalidNodeTypeDefinitionException("circular node auto-creation detected: " + buf.toString());
        }
        QNodeDefinition[] nodeDefs = childNodeENT.getAutoCreateQNodeDefinitions();
        for (int i = 0; i < nodeDefs.length; ++i) {
            Name dnt = nodeDefs[i].getDefaultPrimaryType();
            Name definingNT = nodeDefs[i].getDeclaringNodeType();
            try {
                if (dnt == null) continue;
                definingParentNTs.push(definingNT);
                EffectiveNodeType ent = this.entProvider.getEffectiveNodeType(new Name[]{dnt}, ntdMap);
                this.checkForCircularNodeAutoCreation(ent, definingParentNTs, ntdMap);
                definingParentNTs.pop();
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                String msg = String.valueOf(definingNT) + " defines invalid default node type for child node " + String.valueOf(nodeDefs[i].getName());
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg, e);
            }
            catch (ConstraintViolationException e) {
                String msg = String.valueOf(definingNT) + " defines invalid default node type for child node " + String.valueOf(nodeDefs[i].getName());
                log.debug(msg);
                throw new InvalidNodeTypeDefinitionException(msg, e);
            }
        }
    }

    private void checkNamespace(Name name) throws RepositoryException {
        if (name != null) {
            this.nsRegistry.getPrefix(name.getNamespaceURI());
        }
    }
}

