/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.conversion;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.XMLChar;

public class NameParser {
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;
    private static final int STATE_URI_START = 4;
    private static final int STATE_URI = 5;

    public static Name parse(String jcrName, NamespaceResolver resolver, NameFactory factory) throws IllegalNameException, NamespaceException {
        int len;
        if (jcrName == null) {
            NameParser.complainAndThrow("name is null", "");
        }
        if ((len = jcrName.length()) == 0) {
            NameParser.complainAndThrow("empty name", jcrName);
        }
        if (".".equals(jcrName) || "..".equals(jcrName)) {
            NameParser.complainAndThrow("illegal name", jcrName);
        }
        String prefix = "";
        String uri = null;
        int nameStart = 0;
        int state = 0;
        boolean trailingSpaces = false;
        boolean checkFormat = resolver == null;
        for (int i = 0; i < len; ++i) {
            char c = jcrName.charAt(i);
            if (c == ':') {
                if (state == 0) {
                    NameParser.complainAndThrow("Prefix must not be empty", jcrName, i);
                } else if (state == 1) {
                    if (trailingSpaces) {
                        NameParser.complainAndThrow("Trailing spaces not allowed", jcrName, i);
                    }
                    if (!XMLChar.isValidNCName(prefix = jcrName.substring(0, i))) {
                        NameParser.complainAndThrow("Invalid name prefix: " + prefix, jcrName, i);
                    }
                    state = 2;
                } else if (state != 5) {
                    NameParser.complainAndThrow("'" + NameParser.asDisplayableString(c) + "' not allowed in name", jcrName, i);
                }
                trailingSpaces = false;
                continue;
            }
            if (c == ' ') {
                if (state == 0 || state == 2) {
                    NameParser.complainAndThrow("'" + NameParser.asDisplayableString(c) + "' not valid name start", jcrName, i);
                }
                trailingSpaces = true;
                continue;
            }
            if (c == '[' || c == ']' || c == '*' || c == '|') {
                NameParser.complainAndThrow("'" + NameParser.asDisplayableString(c) + "' not allowed in name", jcrName, i);
                continue;
            }
            if (Character.isWhitespace(c) && c < '\u0080') {
                NameParser.complainAndThrow("Whitespace character '" + NameParser.asDisplayableString(c) + "' not allowed in name", jcrName, i);
                continue;
            }
            if (c == '/') {
                if (state == 4) {
                    state = 5;
                } else if (state != 5) {
                    NameParser.complainAndThrow("'" + NameParser.asDisplayableString(c) + "' not allowed in name", jcrName, i);
                }
                trailingSpaces = false;
                continue;
            }
            if (c == '{') {
                if (state == 0) {
                    state = 4;
                } else if (state == 4 || state == 5) {
                    state = 3;
                    nameStart = 0;
                } else if (state == 2) {
                    state = 3;
                    nameStart = i;
                }
                trailingSpaces = false;
                continue;
            }
            if (c == '}') {
                if (state == 4 || state == 5) {
                    String tmp = jcrName.substring(1, i);
                    if (tmp.length() == 0 || tmp.indexOf(58) != -1) {
                        uri = tmp;
                        state = 2;
                    } else if (tmp.equals("internal")) {
                        uri = tmp;
                        state = 2;
                    } else if (tmp.indexOf(47) == -1) {
                        state = 3;
                        nameStart = 0;
                    } else {
                        NameParser.complainAndThrow("The URI prefix is neither a valid URI nor a valid part of a local name", jcrName);
                    }
                } else if (state == 0) {
                    state = 1;
                } else if (state == 2) {
                    state = 3;
                    nameStart = i;
                }
                trailingSpaces = false;
                continue;
            }
            if (state == 0) {
                state = 1;
            } else if (state == 2) {
                state = 3;
                nameStart = i;
            } else if (state == 4) {
                state = 5;
            }
            trailingSpaces = false;
        }
        if (state == 5 && (jcrName.indexOf(58) > -1 || jcrName.indexOf(47) > -1)) {
            NameParser.complainAndThrow("Local name may not contain ':' nor '/'", jcrName);
        }
        if (nameStart == len || state == 2) {
            NameParser.complainAndThrow("Local name must not be empty", jcrName);
        }
        if (trailingSpaces) {
            NameParser.complainAndThrow("Trailing spaces not allowed", jcrName);
        }
        if (checkFormat) {
            return null;
        }
        if (uri == null) {
            uri = resolver.getURI(prefix);
        }
        String localName = nameStart == 0 ? jcrName : jcrName.substring(nameStart, len);
        return factory.create(uri, localName);
    }

    private static String asDisplayableString(char c) {
        if (c >= ' ' && c < '\u007f') {
            return Character.toString(c);
        }
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\"') {
            return "\\\"";
        }
        return String.format("\\u%04x", c);
    }

    private static String formatNameForDisplay(String name) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            b.append(NameParser.asDisplayableString(name.charAt(i)));
        }
        return b.toString();
    }

    private static void complainAndThrow(String reason, String name) throws IllegalNameException {
        NameParser.complainAndThrow(reason, name, -1);
    }

    private static void complainAndThrow(String reason, String name, int index) throws IllegalNameException {
        String msg = index == -1 ? String.format("%s (name: \"%s\")", reason, NameParser.formatNameForDisplay(name)) : String.format("%s (name: \"%s\", at position: %d)", reason, NameParser.formatNameForDisplay(name), index);
        throw new IllegalNameException(msg);
    }

    public static Name[] parse(String[] jcrNames, NamespaceResolver resolver, NameFactory factory) throws NameException, NamespaceException {
        Name[] ret = new Name[jcrNames.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NameParser.parse(jcrNames[i], resolver, factory);
        }
        return ret;
    }

    public static void checkFormat(String jcrName) throws IllegalNameException {
        try {
            NameParser.parse(jcrName, null, null);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }
}

