/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.CommandLine;
import org.apache.jackrabbit.standalone.cli.ConfigurationException;
import org.apache.jackrabbit.standalone.cli.JcrParserException;
import org.xml.sax.SAXException;

public class CommandLineFactory {
    private static Log log = LogFactory.getLog(CommandLineFactory.class);
    private static ResourceBundle bundle = CommandHelper.getBundle();
    private static final String COMMAND_LINE_FILE = "command-line.xml";
    private static final String COMMAND_LINE_RULES_FILE = "command-line-rules.xml";
    private static CommandLineFactory singleton;
    private Map cache = new TreeMap();
    private Map alias = new HashMap();

    private CommandLineFactory() {
    }

    public static CommandLineFactory getInstance() {
        if (singleton == null) {
            try {
                CommandLineFactory factory = new CommandLineFactory();
                factory.init();
                singleton = factory;
            }
            catch (Exception e) {
                log.error(bundle.getString("exception.unabletoinit"), e);
                e.printStackTrace();
            }
        }
        return singleton;
    }

    public Collection getCommandLines() {
        ArrayList<Object> cls = new ArrayList<Object>();
        for (CommandLine cl : this.cache.values()) {
            cls.add(cl.clone());
        }
        return cls;
    }

    public CommandLine getCommandLine(String name) throws JcrParserException {
        log.debug("lookup command " + name);
        CommandLine original = (CommandLine)this.cache.get(name);
        if (original == null) {
            log.debug("lookup alias " + name);
            original = (CommandLine)this.alias.get(name);
        }
        if (original == null) {
            log.warn("command not found " + name);
            throw new JcrParserException("exception.no.command.for.name", new String[]{name});
        }
        return (CommandLine)original.clone();
    }

    private void init() throws ConfigurationException {
        try {
            URL rulesFile = this.getClass().getResource(COMMAND_LINE_RULES_FILE);
            URL clFile = this.getClass().getResource(COMMAND_LINE_FILE);
            Digester digester = DigesterLoader.createDigester(rulesFile);
            ArrayList cls = new ArrayList();
            digester.push(cls);
            InputStream input = clFile.openStream();
            digester.parse(input);
            input.close();
            for (CommandLine cl : cls) {
                this.cache.put(cl.getName(), cl);
                for (String aliasName : cl.getAlias()) {
                    if (this.alias.containsKey(aliasName)) {
                        throw new ConfigurationException("exception.alias.already.in.use", new String[]{aliasName, cl.getName()});
                    }
                    this.alias.put(aliasName, cl);
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
        catch (SAXException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }
}

