/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.samples.dom;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;

public class ParsingMessage {
    private static String MESSAGE = "MIME-Version: 1.0\r\nFrom: John Doe <jdoe@machine.example>\r\nTo: Mary Smith <mary@example.net>\r\nSubject: Saying Hello\r\nDate: Thu, 24 Jun 2021 14:04:28 +0700\r\nMessage-ID:\r\n <Mime4j.0.8520adcfe13bd088.17a3cd59575@interview1-HP-ProBook-440-G6>\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\nThis is a message just to say hello.\r\nSo, \"Hello\".\r\n";

    public static void main(String[] args) throws Exception {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        Message message = defaultMessageBuilder.parseMessage((InputStream)new ByteArrayInputStream(MESSAGE.getBytes(StandardCharsets.UTF_8)));
        System.out.println("The subject is " + message.getSubject());
        TextBody textBody = (TextBody)message.getBody();
        System.out.println("------------------------------");
        System.out.println("Content: " + IOUtils.toString((InputStream)textBody.getInputStream(), (String)textBody.getMimeCharset()));
        System.out.println("------------------------------");
    }
}

