/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SystemInfoMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String SYSTEM_INFO_MONITOR_OC = "ds-system-info-monitor-entry";
    @NotNull
    private static final String ATTR_AVAILABLE_CPUS = "availableCPUs";
    @NotNull
    private static final String ATTR_CLASSPATH = "classPath";
    @NotNull
    private static final String ATTR_ENVIRONMENT_VARIABLE = "environmentVariable";
    @NotNull
    private static final String ATTR_FREE_MEMORY = "freeUsedMemory";
    @NotNull
    private static final String ATTR_HOSTNAME = "systemName";
    @NotNull
    private static final String ATTR_INSTANCE_ROOT = "instanceRoot";
    @NotNull
    private static final String ATTR_JAVA_HOME = "javaHome";
    @NotNull
    private static final String ATTR_JAVA_VENDOR = "javaVendor";
    @NotNull
    private static final String ATTR_JAVA_VERSION = "javaVersion";
    @NotNull
    private static final String ATTR_JVM_ARCHITECTURE = "jvmArchitecture";
    @NotNull
    private static final String ATTR_JVM_ARGUMENTS = "jvmArguments";
    @NotNull
    private static final String ATTR_JVM_PID = "jvmPID";
    @NotNull
    private static final String ATTR_JVM_VENDOR = "jvmVendor";
    @NotNull
    private static final String ATTR_JVM_VERSION = "jvmVersion";
    @NotNull
    private static final String ATTR_MAX_MEMORY = "maxMemory";
    @NotNull
    private static final String ATTR_OPERATING_SYSTEM = "operatingSystem";
    @NotNull
    private static final String ATTR_SSL_CONTEXT_PROTOCOL = "sslContextProtocol";
    @NotNull
    private static final String ATTR_SYSTEM_PROPERTY = "systemProperty";
    @NotNull
    private static final String ATTR_USED_MEMORY = "usedMemory";
    @NotNull
    private static final String ATTR_USER_NAME = "userName";
    @NotNull
    private static final String ATTR_WORKING_DIRECTORY = "workingDirectory";
    private static final long serialVersionUID = 2709857663883498069L;
    @Nullable
    private final Long availableCPUs = this.getLong("availableCPUs");
    @Nullable
    private final Long freeMemory;
    @Nullable
    private final Long jvmPID;
    @Nullable
    private final Long maxMemory;
    @Nullable
    private final Long usedMemory;
    @NotNull
    private final Map<String, String> environmentVariables;
    @NotNull
    private final Map<String, String> systemProperties;
    @Nullable
    private final String classpath = this.getString("classPath");
    @Nullable
    private final String hostname;
    @Nullable
    private final String instanceRoot;
    @Nullable
    private final String javaHome;
    @Nullable
    private final String javaVendor;
    @Nullable
    private final String javaVersion;
    @Nullable
    private final String jvmArchitecture;
    @Nullable
    private final String jvmArguments;
    @Nullable
    private final String jvmVendor;
    @Nullable
    private final String jvmVersion;
    @Nullable
    private final String operatingSystem;
    @Nullable
    private final String sslContextProtocol;
    @Nullable
    private final String userName;
    @Nullable
    private final String workingDirectory;

    public SystemInfoMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.freeMemory = this.getLong(ATTR_FREE_MEMORY);
        this.hostname = this.getString(ATTR_HOSTNAME);
        this.instanceRoot = this.getString(ATTR_INSTANCE_ROOT);
        this.javaHome = this.getString(ATTR_JAVA_HOME);
        this.javaVendor = this.getString(ATTR_JAVA_VENDOR);
        this.javaVersion = this.getString(ATTR_JAVA_VERSION);
        this.jvmArchitecture = this.getString(ATTR_JVM_ARCHITECTURE);
        this.jvmArguments = this.getString(ATTR_JVM_ARGUMENTS);
        this.jvmPID = this.getLong(ATTR_JVM_PID);
        this.jvmVendor = this.getString(ATTR_JVM_VENDOR);
        this.jvmVersion = this.getString(ATTR_JVM_VERSION);
        this.maxMemory = this.getLong(ATTR_MAX_MEMORY);
        this.operatingSystem = this.getString(ATTR_OPERATING_SYSTEM);
        this.sslContextProtocol = this.getString(ATTR_SSL_CONTEXT_PROTOCOL);
        this.usedMemory = this.getLong(ATTR_USED_MEMORY);
        this.userName = this.getString(ATTR_USER_NAME);
        this.workingDirectory = this.getString(ATTR_WORKING_DIRECTORY);
        List<String> envValues = this.getStrings(ATTR_ENVIRONMENT_VARIABLE);
        LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(envValues.size()));
        for (String s : envValues) {
            int eqPos = s.indexOf("='");
            if (eqPos <= 0) continue;
            String name = s.substring(0, eqPos);
            if (eqPos == s.length() - 2) continue;
            envMap.put(name, s.substring(eqPos + 2, s.length() - 1));
        }
        this.environmentVariables = Collections.unmodifiableMap(envMap);
        List<String> propValues = this.getStrings(ATTR_SYSTEM_PROPERTY);
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(propValues.size()));
        for (String s : propValues) {
            int eqPos = s.indexOf("='");
            if (eqPos <= 0) continue;
            String name = s.substring(0, eqPos);
            if (eqPos == s.length() - 2) continue;
            propMap.put(name, s.substring(eqPos + 2, s.length() - 1));
        }
        this.systemProperties = Collections.unmodifiableMap(propMap);
    }

    @Nullable
    public Long getAvailableCPUs() {
        return this.availableCPUs;
    }

    @Nullable
    public String getClassPath() {
        return this.classpath;
    }

    @NotNull
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public Long getFreeMemory() {
        return this.freeMemory;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @Nullable
    public String getInstanceRoot() {
        return this.instanceRoot;
    }

    @Nullable
    public String getJavaHome() {
        return this.javaHome;
    }

    @Nullable
    public String getJavaVendor() {
        return this.javaVendor;
    }

    @Nullable
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Nullable
    public String getJVMArchitectureDataModel() {
        return this.jvmArchitecture;
    }

    @Nullable
    public String getJVMArguments() {
        return this.jvmArguments;
    }

    @Nullable
    public Long getJVMPID() {
        return this.jvmPID;
    }

    @Nullable
    public String getJVMVendor() {
        return this.jvmVendor;
    }

    @Nullable
    public String getJVMVersion() {
        return this.jvmVersion;
    }

    @Nullable
    public Long getMaxMemory() {
        return this.maxMemory;
    }

    @Nullable
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    @Nullable
    public String getSSLContextProtocol() {
        return this.sslContextProtocol;
    }

    @NotNull
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Nullable
    public Long getUsedMemory() {
        return this.usedMemory;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_SYSTEM_INFO_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_SYSTEM_INFO_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(30));
        if (this.hostname != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_HOSTNAME, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_HOSTNAME.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_HOSTNAME.get(), this.hostname);
        }
        if (this.operatingSystem != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_OPERATING_SYSTEM, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_OPERATING_SYSTEM.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_OPERATING_SYSTEM.get(), this.operatingSystem);
        }
        if (this.jvmArchitecture != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_ARCHITECTURE, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JVM_ARCHITECTURE.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JVM_ARCHITECTURE.get(), this.jvmArchitecture);
        }
        if (this.javaHome != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JAVA_HOME, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JAVA_HOME.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JAVA_HOME.get(), this.javaHome);
        }
        if (this.javaVersion != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JAVA_VERSION, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JAVA_VERSION.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JAVA_VERSION.get(), this.javaVersion);
        }
        if (this.javaVendor != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JAVA_VENDOR, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JAVA_VENDOR.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JAVA_VENDOR.get(), this.javaVendor);
        }
        if (this.jvmVersion != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_VERSION, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JVM_VERSION.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JVM_VERSION.get(), this.jvmVersion);
        }
        if (this.jvmVendor != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_VENDOR, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JVM_VENDOR.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JVM_VENDOR.get(), this.jvmVendor);
        }
        if (this.jvmArguments != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_ARGUMENTS, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JVM_ARGUMENTS.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JVM_ARGUMENTS.get(), this.jvmArguments);
        }
        if (this.jvmPID != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_PID, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_JVM_PID.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_JVM_PID.get(), this.jvmPID);
        }
        if (this.sslContextProtocol != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_SSL_CONTEXT_PROTOCOL, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_SSL_CONTEXT_PROTOCOL.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_SSL_CONTEXT_PROTOCOL.get(), this.sslContextProtocol);
        }
        if (this.classpath != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_CLASSPATH, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_CLASSPATH.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_CLASSPATH.get(), this.classpath);
        }
        if (this.instanceRoot != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_INSTANCE_ROOT, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_INSTANCE_ROOT.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_INSTANCE_ROOT.get(), this.instanceRoot);
        }
        if (this.workingDirectory != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_WORKING_DIRECTORY, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_WORKING_DIRECTORY.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_WORKING_DIRECTORY.get(), this.workingDirectory);
        }
        if (this.availableCPUs != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_AVAILABLE_CPUS, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_AVAILABLE_CPUS.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_AVAILABLE_CPUS.get(), this.availableCPUs);
        }
        if (this.usedMemory != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_USED_MEMORY, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_USED_MEMORY.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_USED_MEMORY.get(), this.usedMemory);
        }
        if (this.maxMemory != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_MEMORY, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_MAX_MEMORY.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_MAX_MEMORY.get(), this.maxMemory);
        }
        if (this.freeMemory != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_FREE_MEMORY, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_FREE_MEMORY.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_FREE_MEMORY.get(), this.freeMemory);
        }
        if (this.userName != null) {
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_USER_NAME, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_USER_NAME.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_USER_NAME.get(), this.userName);
        }
        if (!this.environmentVariables.isEmpty()) {
            ArrayList<String> envList = new ArrayList<String>(this.environmentVariables.size());
            for (Map.Entry<String, String> e : this.environmentVariables.entrySet()) {
                envList.add(e.getKey() + "='" + e.getValue() + '\'');
            }
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_ENVIRONMENT_VARIABLE, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_ENV_VAR.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_ENV_VAR.get(), envList);
        }
        if (!this.systemProperties.isEmpty()) {
            ArrayList<String> propList = new ArrayList<String>(this.systemProperties.size());
            for (Map.Entry<String, String> e : this.systemProperties.entrySet()) {
                propList.add(e.getKey() + "='" + e.getValue() + '\'');
            }
            SystemInfoMonitorEntry.addMonitorAttribute(attrs, ATTR_SYSTEM_PROPERTY, MonitorMessages.INFO_SYSTEM_INFO_DISPNAME_SYSTEM_PROP.get(), MonitorMessages.INFO_SYSTEM_INFO_DESC_SYSTEM_PROP.get(), propList);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

